"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchPutMetricAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
const role_1 = require("./private/role");
/**
 * The action to capture an Amazon CloudWatch metric.
 */
class CloudWatchPutMetricAction {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_CloudWatchPutMetricActionProps(props);
    }
    bind(rule) {
        var _b;
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        cloudwatch.Metric.grantPutMetricData(role);
        return {
            configuration: {
                cloudwatchMetric: {
                    metricName: this.props.metricName,
                    metricNamespace: this.props.metricNamespace,
                    metricTimestamp: this.props.metricTimestamp,
                    metricUnit: this.props.metricUnit,
                    metricValue: this.props.metricValue,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.CloudWatchPutMetricAction = CloudWatchPutMetricAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchPutMetricAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.CloudWatchPutMetricAction", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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