"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisPutRecordAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to put the record from an MQTT message to the Kinesis Data stream.
 */
class KinesisPutRecordAction {
    /**
     * @param stream The Kinesis Data stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props) {
        this.stream = stream;
        jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_KinesisPutRecordActionProps(props);
        this.partitionKey = props.partitionKey;
        this.role = props.role;
    }
    bind(rule) {
        var _b;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['kinesis:PutRecord'],
            resources: [this.stream.streamArn],
        }));
        return {
            configuration: {
                kinesis: {
                    streamName: this.stream.streamName,
                    partitionKey: this.partitionKey || undefined,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.KinesisPutRecordAction = KinesisPutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
KinesisPutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.KinesisPutRecordAction", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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