"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NamedQuery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_athena_1 = require("aws-cdk-lib/aws-athena");
class NamedQuery extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the NamedQuery class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in
       * the construct tree.
       * @param id A name to be associated with the stack and used in resource
       * naming. Must be unique within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.database = props.database;
        this.description = props.description;
        this.name = props.name ?? aws_cdk_lib_1.Names.nodeUniqueId(this.node);
        this.queryString = props.queryString;
        this.resource = new aws_athena_1.CfnNamedQuery(this, 'Resource', {
            database: this.database.databaseName,
            description: this.description,
            name: this.name,
            queryString: this.queryString,
        });
        this.namedQueryId = this.resource.attrNamedQueryId;
        this.namedQueryName = this.resource.ref;
    }
}
exports.NamedQuery = NamedQuery;
_a = JSII_RTTI_SYMBOL_1;
NamedQuery[_a] = { fqn: "cdk-extensions.athena.NamedQuery", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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