import { IResolvable } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { Shard } from './shard';
export interface BasicClusterOptions {
    readonly availabilityZones?: string[];
    readonly replicas?: number;
}
export interface SimpleShardingOptions {
    readonly replicas?: number;
    readonly shards?: number;
}
export interface ReplicationGroupClusterConfiguration {
    readonly nodeGroupConfiguration?: IResolvable;
    readonly numCacheClusters?: number;
    readonly numNodeGroups?: number;
    readonly preferredCacheClusterAZs?: string[];
    readonly replicasPerNodeGroup?: number;
}
export declare class ClusterConfiguration {
    static basic(options?: BasicClusterOptions): ClusterConfiguration;
    static complexSharding(...shards: Shard[]): ClusterConfiguration;
    static simpleSharding(options?: SimpleShardingOptions): ClusterConfiguration;
    private readonly basicOptions?;
    private readonly sharding;
    private readonly shards;
    private constructor();
    addAvailabilityZone(zone: string): ClusterConfiguration;
    addShard(shard: Shard): void;
    bind(scope: IConstruct): ReplicationGroupClusterConfiguration;
    private hasComplexSharding;
}
