"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedisEngine = exports.CacheEngine = exports.CacheEngineFamily = exports.CacheEngineName = void 0;
var CacheEngineName;
(function (CacheEngineName) {
    CacheEngineName["MEMCACHED"] = "memcached";
    CacheEngineName["REDIS"] = "redis";
})(CacheEngineName = exports.CacheEngineName || (exports.CacheEngineName = {}));
class CacheEngineFamily {
    constructor(name) {
        this.name = name;
    }
    static of(name) {
        return new CacheEngineFamily(name);
    }
}
exports.CacheEngineFamily = CacheEngineFamily;
CacheEngineFamily.MEMCACHED_1_4 = CacheEngineFamily.of('memcached1.4');
CacheEngineFamily.MEMCACHED_1_5 = CacheEngineFamily.of('memcached1.5');
CacheEngineFamily.MEMCACHED_1_6 = CacheEngineFamily.of('memcached1.6');
CacheEngineFamily.REDIS_2_6 = CacheEngineFamily.of('redis2.6');
CacheEngineFamily.REDIS_2_8 = CacheEngineFamily.of('redis2.8');
CacheEngineFamily.REDIS_3_2 = CacheEngineFamily.of('redis3.2');
CacheEngineFamily.REDIS_4_0 = CacheEngineFamily.of('redis4.0');
CacheEngineFamily.REDIS_5_0 = CacheEngineFamily.of('redis5.0');
CacheEngineFamily.REDIS_6_X = CacheEngineFamily.of('redis6.x');
class CacheEngine {
    constructor(name, version, options) {
        this.engineName = name;
        this.engineVersion = version;
        this.engineFamily = options?.engineFamily ?? CacheEngineFamily.of(`${name}${version.split('.')[0]}.x`);
    }
}
exports.CacheEngine = CacheEngine;
class RedisEngine extends CacheEngine {
    constructor(version, options) {
        super(CacheEngineName.REDIS, version);
        this.defaultPort = 6379;
        this.transitEncryptionSupported = options?.transitEncryptionSupported ?? true;
    }
    static of(version, options) {
        return new RedisEngine(version, options);
    }
}
exports.RedisEngine = RedisEngine;
RedisEngine.V_2_6_13 = RedisEngine.of('2.6.13', {
    engineFamily: CacheEngineFamily.REDIS_2_6,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_6 = RedisEngine.of('2.8.6', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_19 = RedisEngine.of('2.8.19', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_21 = RedisEngine.of('2.8.21', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_22 = RedisEngine.of('2.8.22', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_23 = RedisEngine.of('2.8.23', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_2_8_24 = RedisEngine.of('2.8.24', {
    engineFamily: CacheEngineFamily.REDIS_2_8,
    transitEncryptionSupported: false,
});
RedisEngine.V_3_2_4 = RedisEngine.of('3.2.4', {
    engineFamily: CacheEngineFamily.REDIS_3_2,
    transitEncryptionSupported: false,
});
RedisEngine.V_3_2_6 = RedisEngine.of('3.2.6', {
    engineFamily: CacheEngineFamily.REDIS_3_2,
    transitEncryptionSupported: true,
});
RedisEngine.V_3_2_10 = RedisEngine.of('3.2.10', {
    engineFamily: CacheEngineFamily.REDIS_3_2,
    transitEncryptionSupported: true,
});
RedisEngine.V_4_0_10 = RedisEngine.of('4.0.10', {
    engineFamily: CacheEngineFamily.REDIS_4_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_0 = RedisEngine.of('5.0.0', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_3 = RedisEngine.of('5.0.3', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_4 = RedisEngine.of('5.0.4', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_5 = RedisEngine.of('5.0.5', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_5_0_6 = RedisEngine.of('5.0.6', {
    engineFamily: CacheEngineFamily.REDIS_5_0,
    transitEncryptionSupported: true,
});
RedisEngine.V_6_0 = RedisEngine.of('6.0', {
    engineFamily: CacheEngineFamily.REDIS_6_X,
    transitEncryptionSupported: true,
});
RedisEngine.V_6_2 = RedisEngine.of('6.2', {
    engineFamily: CacheEngineFamily.REDIS_6_X,
    transitEncryptionSupported: true,
});
//# sourceMappingURL=data:application/json;base64,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