"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDestination = exports.LogDestinationType = void 0;
var LogDestinationType;
(function (LogDestinationType) {
    LogDestinationType["CLOUDWATCH"] = "cloudwatch-logs";
    LogDestinationType["FIREHOSE"] = "kinesis-firehose";
})(LogDestinationType = exports.LogDestinationType || (exports.LogDestinationType = {}));
class LogDestination {
    constructor(configuration) {
        this.configuration = configuration;
    }
    static cloudwatch(logGroup) {
        return new LogDestination({
            destinationDetails: {
                cloudWatchLogsDetails: {
                    logGroup: logGroup.logGroupName,
                },
            },
            destinationType: LogDestinationType.CLOUDWATCH,
        });
    }
    static firehose(deliveryStream) {
        return new LogDestination({
            destinationDetails: {
                kinesisFirehoseDetails: {
                    deliveryStream: deliveryStream.deliveryStreamName,
                },
            },
            destinationType: LogDestinationType.FIREHOSE,
        });
    }
    bind(_scope) {
        return this.configuration;
    }
}
exports.LogDestination = LogDestination;
//# sourceMappingURL=data:application/json;base64,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