"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudtrailTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const region_info_1 = require("aws-cdk-lib/region-info");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class CloudtrailTable extends glue_1.Table {
    /**
       * Creates a new instance of the FlowLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        const projectionYear = new Date().getFullYear() - 1;
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'eventVersion',
                    type: 'string',
                }),
                new glue_1.StructColumn({
                    name: 'userIdentity',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'type',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'principalId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'arn',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'accountId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'invokedBy',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'accessKeyId',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'userName',
                            type: 'string',
                        }),
                        new glue_1.StructColumn({
                            name: 'sessionContext',
                            data: [
                                new glue_1.StructColumn({
                                    name: 'attributes',
                                    data: [
                                        new glue_1.BasicColumn({
                                            name: 'mfaAuthenticated',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'creationDate',
                                            type: 'string',
                                        }),
                                    ],
                                }),
                                new glue_1.StructColumn({
                                    name: 'sessionIssuer',
                                    data: [
                                        new glue_1.BasicColumn({
                                            name: 'type',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'principalId',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'arn',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'accountId',
                                            type: 'string',
                                        }),
                                        new glue_1.BasicColumn({
                                            name: 'userName',
                                            type: 'string',
                                        }),
                                    ],
                                }),
                            ],
                        }),
                    ],
                }),
                new glue_1.BasicColumn({
                    name: 'eventTime',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'eventSource',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'eventName',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'awsRegion',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'sourceIpAddress',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'userAgent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'errorCode',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'errorMessage',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'requestParameters',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'responseElements',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'additionalEventData',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'requestId',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'eventId',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'readOnly',
                    type: 'string',
                }),
                new glue_1.ArrayColumn({
                    name: 'resources',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'arn',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'accountId',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'type',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.BasicColumn({
                    name: 'eventType',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'apiVersion',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'recipientAccountId',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'serviceEventDetails',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'sharedEventID',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'vpcendpointid',
                    type: 'string',
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.CLOUDTRAIL,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.CLOUDTRAIL,
            },
            database: props.database,
            description: 'Table used for querying AWS API history.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'projection.day.format': 'yyyy/MM/dd',
                'projection.day.interval': '1',
                'projection.day.range': `${projectionYear}/01/01,NOW`,
                'projection.day.type': 'date',
                'projection.day.interval.unit': 'DAYS',
                'projection.logname.type': 'enum',
                'projection.logname.values': 'CloudTrail',
                'projection.regionname.type': 'enum',
                'projection.regionname.values': region_info_1.RegionInfo.regions.map((x) => {
                    return x.name;
                }).join(','),
                'projection.source.type': 'enum',
                'projection.source.values': aws_cdk_lib_1.Lazy.string({
                    produce: () => {
                        if (aws_cdk_lib_1.Token.isUnresolved(this.stack.account)) {
                            aws_cdk_lib_1.Annotations.of(this).addWarning([
                                `CloudTrail table stack for ${this.node.path} is environment agnostic.`,
                                'Cross account partition projection cannot be configured on environment',
                                'agnostic stacks. To enable partition projection please specify an account',
                                `for the ${this.stack.node.path} stack.`,
                            ].join(' '));
                            return this.stack.account;
                        }
                        else {
                            return [...new Set(this.node.root.node.findAll().reduce((prev, cur) => {
                                    if ((cur instanceof aws_cdk_lib_1.Stage || cur instanceof aws_cdk_lib_1.Stack) && cur.account && !aws_cdk_lib_1.Token.isUnresolved(cur.account)) {
                                        prev.push(cur.account);
                                    }
                                    return prev;
                                }, []))].join(',');
                        }
                    },
                }),
                'projection.enabled': 'true',
                'storage.location.template': `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/\${source}/\${logname}/\${regionname}/\${day}`,
            },
            partitionKeys: [
                new glue_1.BasicColumn({
                    name: 'source',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'logname',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'regionname',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'day',
                    type: 'string',
                }),
            ],
            serdeParameters: {
                'serialization.format': '1',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.unauthorizedNamedQuery = new athena_1.NamedQuery(this, 'unauthorized-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent unauthorized AWS API calls.',
                name: this.friendlyQueryNames ? 'cloudtrail-unauthorized-errors' : undefined,
                queryString: [
                    "SELECT FROM_ISO8601_TIMESTAMP(eventtime) AT TIME ZONE 'UTC' AS time,",
                    "    CONCAT(SPLIT(eventsource, '.')[1], ':', eventname) AS event,",
                    '    useridentity.arn as entity,',
                    '    useridentity.accountid as srcaccount,',
                    '    recipientaccountid as dstaccount,',
                    '    awsregion,',
                    '    errormessage,',
                    '    requestparameters as params',
                    `FROM ${this.tableName}`,
                    "WHERE (errorcode LIKE 'AccessDenied%' OR errorcode LIKE '%UnauthorizedOperation')",
                    "    AND day >= DATE_FORMAT(NOW() - PARSE_DURATION('1d'), '%Y/%m/%d')",
                    "    AND FROM_ISO8601_TIMESTAMP(eventtime) >= NOW() - PARSE_DURATION('1d')",
                    'ORDER BY eventtime DESC LIMIT 100;',
                ].join('\n'),
            });
            this.userLoginsNamedQuery = new athena_1.NamedQuery(this, 'user-logins-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent AWS user logins.',
                name: this.friendlyQueryNames ? 'cloudtrail-user-logins' : undefined,
                queryString: [
                    "SELECT FROM_ISO8601_TIMESTAMP(eventtime) AT TIME ZONE 'UTC' AS time,",
                    "    CONCAT(SPLIT(eventsource, '.')[1], ':', eventname) AS event,",
                    '    useridentity.username as username,',
                    '    useridentity.accountid as account,',
                    '    awsregion',
                    `FROM ${this.tableName}`,
                    "WHERE eventname = 'ConsoleLogin'",
                    "    AND day >= DATE_FORMAT(NOW() - PARSE_DURATION('30d'), '%Y/%m/%d')",
                    "    AND FROM_ISO8601_TIMESTAMP(eventtime) >= NOW() - PARSE_DURATION('30d')",
                    'ORDER BY eventtime DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.CloudtrailTable = CloudtrailTable;
_a = JSII_RTTI_SYMBOL_1;
CloudtrailTable[_a] = { fqn: "cdk-extensions.glue_tables.CloudtrailTable", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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