import { ResourceProps } from 'aws-cdk-lib';
import { CfnTable } from 'aws-cdk-lib/aws-glue';
import { IBucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { NamedQuery } from '../athena';
import { FlowLogFormat } from '../ec2';
import { Database, Table } from '../glue';
/**
 * Configuration for FlowLogsTable
 */
export interface FlowLogsTableProps extends ResourceProps {
    readonly bucket: IBucket;
    readonly createQueries?: boolean;
    readonly database: Database;
    readonly format?: FlowLogFormat;
    readonly friendlyQueryNames?: boolean;
    readonly name?: string;
    readonly s3Prefix?: string;
}
export declare class FlowLogsTable extends Table {
    readonly createQueries: boolean;
    readonly format: FlowLogFormat;
    readonly friendlyQueryNames: boolean;
    readonly internalRejectedNamedQuery?: NamedQuery;
    /**
       * Creates a new instance of the FlowLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props: FlowLogsTableProps);
    protected renderStorageDescriptor(): CfnTable.StorageDescriptorProperty | undefined;
}
