"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3AccessLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const athena_1 = require("../athena");
const glue_1 = require("../glue");
class S3AccessLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the S3AccessLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'bucket_owner',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'bucket_name',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_datetime',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'remote_ip',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'requester',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'operation',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'key',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'request_uri',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'http_status',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'error_code',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'bytes_sent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'object_size',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'total_time',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'turnaround_time',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'referrer',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'user_agent',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'version_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'host_id',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'sigv',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'cipher_suite',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'auth_type',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'endpoint',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'tls_version',
                    type: 'string',
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.REGEXP,
            },
            database: props.database,
            description: 'Table used for querying S3 access logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                EXTERNAL: 'TRUE',
            },
            serdeParameters: {
                'input.regex': '([^ ]*) ([^ ]*) \\[(.*?)\\] ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) (\"[^\"]*\"|-) (-|[0-9]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) (\"[^\"]*\"|-) ([^ ]*)(?: ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*) ([^ ]*))?.*$',
            },
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
        if (this.createQueries) {
            this.requestErrorsNamedQuery = new athena_1.NamedQuery(this, 'reqest-errors-named-query', {
                database: this.database,
                description: 'Gets the 100 most recent failed S3 access requests.',
                name: this.friendlyQueryNames ? 's3-request-errors' : undefined,
                queryString: [
                    'SELECT PARSE_DATETIME(request_datetime, \'d/MMM/y:H:m:s Z\') AT TIME ZONE \'UTC\' AS "timestamp",',
                    '    remote_ip AS client_ip,',
                    '    http_status AS status_code,',
                    '    error_code,',
                    '    operation,',
                    '    request_id,',
                    '    CASE',
                    "        WHEN key = '-' THEN CONCAT('s3://', bucket_name, '/')",
                    "        ELSE CONCAT('s3://', bucket_name, '/', key)",
                    '    END AS object',
                    `FROM ${this.tableName}`,
                    'WHERE CAST(http_status AS integer) BETWEEN 400 AND 599',
                    "    AND PARSE_DATETIME(request_datetime, 'd/MMM/y:H:m:s Z') >= NOW() - PARSE_DURATION('1d')",
                    'ORDER BY "timestamp" DESC LIMIT 100;',
                ].join('\n'),
            });
        }
    }
}
exports.S3AccessLogsTable = S3AccessLogsTable;
_a = JSII_RTTI_SYMBOL_1;
S3AccessLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.S3AccessLogsTable", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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