"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafLogsTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const region_info_1 = require("aws-cdk-lib/region-info");
const glue_1 = require("../glue");
class WafLogsTable extends glue_1.Table {
    /**
       * Creates a new instance of the S3AccessLogsTable class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, {
            columns: [
                new glue_1.BasicColumn({
                    name: 'timestamp',
                    type: 'bigint',
                }),
                new glue_1.BasicColumn({
                    name: 'formatversion',
                    type: 'int',
                }),
                new glue_1.BasicColumn({
                    name: 'webaclid',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'terminatingruleid',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'terminatingruletype',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'action',
                    type: 'string',
                }),
                new glue_1.ArrayColumn({
                    name: 'terminatingrulematchdetails',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'conditiontype',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'location',
                                type: 'string',
                            }),
                            new glue_1.ArrayColumn({
                                name: 'matcheddata',
                                data: new glue_1.BasicColumn({
                                    type: 'string',
                                }),
                            }),
                        ],
                    }),
                }),
                new glue_1.BasicColumn({
                    name: 'httpsourcename',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'httpsourceid',
                    type: 'string',
                }),
                new glue_1.ArrayColumn({
                    name: 'rulegrouplist',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'rulegroupid',
                                type: 'string',
                            }),
                            new glue_1.StructColumn({
                                name: 'terminatingrule',
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'ruleid',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'action',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'rulematchdetails',
                                        type: 'string',
                                    }),
                                ],
                            }),
                            new glue_1.ArrayColumn({
                                name: 'nonterminatingmatchingrules',
                                data: new glue_1.BasicColumn({
                                    type: 'string',
                                }),
                            }),
                            new glue_1.BasicColumn({
                                name: 'excludedrules',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.ArrayColumn({
                    name: 'ratebasedrulelist',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'ratebasedruleid',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'limitkey',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'maxrateallowed',
                                type: 'int',
                            }),
                        ],
                    }),
                }),
                new glue_1.ArrayColumn({
                    name: 'nonterminatingmatchingrules',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'ruleid',
                                type: 'string',
                            }),
                            new glue_1.BasicColumn({
                                name: 'action',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.BasicColumn({
                    name: 'requestheadersinserted',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'responsecodesent',
                    type: 'string',
                }),
                new glue_1.StructColumn({
                    name: 'httprequest',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'clientip',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'country',
                            type: 'string',
                        }),
                        new glue_1.ArrayColumn({
                            name: 'headers',
                            data: new glue_1.StructColumn({
                                data: [
                                    new glue_1.BasicColumn({
                                        name: 'name',
                                        type: 'string',
                                    }),
                                    new glue_1.BasicColumn({
                                        name: 'value',
                                        type: 'string',
                                    }),
                                ],
                            }),
                        }),
                        new glue_1.BasicColumn({
                            name: 'uri',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'args',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'httpversion',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'httpmethod',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'requestid',
                            type: 'string',
                        }),
                    ],
                }),
                new glue_1.ArrayColumn({
                    name: 'labels',
                    data: new glue_1.StructColumn({
                        data: [
                            new glue_1.BasicColumn({
                                name: 'name',
                                type: 'string',
                            }),
                        ],
                    }),
                }),
                new glue_1.StructColumn({
                    name: 'captcharesponse',
                    data: [
                        new glue_1.BasicColumn({
                            name: 'responsecode',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'solvetimestamp',
                            type: 'string',
                        }),
                        new glue_1.BasicColumn({
                            name: 'failureReason',
                            type: 'string',
                        }),
                    ],
                }),
            ],
            compressed: false,
            dataFormat: {
                inputFormat: glue_1.InputFormat.TEXT,
                outputFormat: glue_1.OutputFormat.HIVE_IGNORE_KEY_TEXT,
                serializationLibrary: glue_1.SerializationLibrary.OPENX_JSON,
            },
            database: props.database,
            description: 'Table used for querying AWS WAF logs.',
            location: `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/`,
            name: props.name,
            owner: 'hadoop',
            parameters: {
                'EXTERNAL': 'TRUE',
                'projection.region.type': 'enum',
                'projection.region.values': region_info_1.RegionInfo.regions.map((x) => {
                    return x.name;
                }).join(','),
                'projection.account.type': 'enum',
                'projection.account.values': aws_cdk_lib_1.Lazy.string({
                    produce: () => {
                        if (aws_cdk_lib_1.Token.isUnresolved(this.stack.account)) {
                            aws_cdk_lib_1.Annotations.of(this).addWarning([
                                `Flow logs table stack for ${this.node.path} is environment agnostic.`,
                                'Cross account partition projection cannot be configured on environment',
                                'agnostic stacks. To enable partition projection please specify an account',
                                `for the ${this.stack.node.path} stack.`,
                            ].join(' '));
                            return this.stack.account;
                        }
                        else {
                            return [...new Set(this.node.root.node.findAll().reduce((prev, cur) => {
                                    if ((cur instanceof aws_cdk_lib_1.Stage || cur instanceof aws_cdk_lib_1.Stack) && cur.account && !aws_cdk_lib_1.Token.isUnresolved(cur.account)) {
                                        prev.push(cur.account);
                                    }
                                    return prev;
                                }, []))].join(',');
                        }
                    },
                }),
                'projection.enabled': 'true',
                'storage.location.template': `s3://${props.bucket.bucketName}/${props.s3Prefix ?? ''}AWSLogs/\${account}/WAFLogs/\${region}/`,
            },
            partitionKeys: [
                new glue_1.BasicColumn({
                    name: 'account',
                    type: 'string',
                }),
                new glue_1.BasicColumn({
                    name: 'region',
                    type: 'string',
                }),
            ],
            storedAsSubDirectories: false,
            tableType: glue_1.TableType.EXTERNAL_TABLE,
        });
        this.createQueries = props.createQueries ?? true;
        this.friendlyQueryNames = props.friendlyQueryNames ?? false;
    }
}
exports.WafLogsTable = WafLogsTable;
_a = JSII_RTTI_SYMBOL_1;
WafLogsTable[_a] = { fqn: "cdk-extensions.glue_tables.WafLogsTable", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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