import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Connections, IConnectable, ISecurityGroup, IVpc, SecurityGroup, SubnetSelection } from 'aws-cdk-lib/aws-ec2';
import { CfnConnection } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
export declare enum ConnectionType {
    JDBC = "JDBC",
    KAFKA = "KAFKA",
    MONGODB = "MONGODB",
    NETWORK = "NETWORK"
}
/**
 * Configuration for the Glue Workflow resource.
 */
export interface ConnectionProps extends ResourceProps {
    readonly connectionType: ConnectionType;
    readonly description?: string;
    readonly name?: string;
    readonly properties?: {
        [key: string]: string;
    };
    readonly securityGroups?: ISecurityGroup[];
    readonly subnets?: SubnetSelection;
    readonly vpc?: IVpc;
}
export declare class Connection extends Resource implements IConnectable {
    private readonly _matchCriteria;
    private readonly _properties;
    readonly connectionType: ConnectionType;
    readonly description?: string;
    readonly name?: string;
    readonly securityGroups: ISecurityGroup[];
    readonly subnets?: SubnetSelection;
    readonly vpc?: IVpc;
    readonly resource: CfnConnection;
    readonly securityGroup?: SecurityGroup;
    readonly connectionArn: string;
    readonly connectionName: string;
    readonly connections: Connections;
    constructor(scope: Construct, id: string, props: ConnectionProps);
    addMatchCriteria(value: string): void;
    addProperty(key: string, value: string): void;
}
