"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = exports.ConnectionType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
const formatting_1 = require("../utils/formatting");
var ConnectionType;
(function (ConnectionType) {
    ConnectionType["JDBC"] = "JDBC";
    ConnectionType["KAFKA"] = "KAFKA";
    ConnectionType["MONGODB"] = "MONGODB";
    ConnectionType["NETWORK"] = "NETWORK";
})(ConnectionType = exports.ConnectionType || (exports.ConnectionType = {}));
class Connection extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._matchCriteria = [];
        this._properties = {};
        this.connectionType = props.connectionType;
        this.description = props.description;
        this.name = props.name;
        this.securityGroups = props.securityGroups ?? [];
        this.subnets = props.subnets ?? {
            onePerAz: true,
        };
        this.vpc = props.vpc;
        const properties = props?.properties ?? {};
        Object.keys(properties).forEach((x) => {
            this.addProperty(x, properties[x]);
        });
        const subnet = this.vpc?.selectSubnets(this.subnets).subnets[0];
        if (this.vpc && this.securityGroups.length === 0) {
            this.securityGroup = new aws_ec2_1.SecurityGroup(this, 'security-group', {
                description: 'Provides connectivity for Glue Connection',
                vpc: this.vpc,
            });
            this.securityGroups.push(this.securityGroup);
        }
        this.connections = new aws_ec2_1.Connections({
            securityGroups: this.securityGroups,
        });
        this.connections.allowFromAnyIpv4(aws_ec2_1.Port.allTraffic(), 'Required by Glue Connections');
        this.resource = new aws_glue_1.CfnConnection(this, 'Resource', {
            catalogId: this.stack.account,
            connectionInput: {
                connectionProperties: aws_cdk_lib_1.Lazy.uncachedAny({
                    produce: () => {
                        return !!Object.keys(this._properties).length ? this._properties : undefined;
                    },
                }),
                connectionType: this.connectionType,
                description: this.description,
                matchCriteria: aws_cdk_lib_1.Lazy.uncachedList({
                    produce: () => {
                        return this._matchCriteria;
                    },
                }, {
                    omitEmpty: true,
                }),
                name: this.name,
                physicalConnectionRequirements: formatting_1.undefinedIfNoKeys({
                    availabilityZone: subnet?.availabilityZone,
                    securityGroupIdList: !!!this.vpc ? undefined : this.securityGroups.map((x) => {
                        return x.securityGroupId;
                    }),
                    subnetId: subnet?.subnetId,
                }),
            },
        });
        this.connectionArn = this.stack.formatArn({
            resource: 'connection',
            resourceName: this.resource.ref,
            service: 'glue',
        });
        this.connectionName = this.resource.ref;
    }
    addMatchCriteria(value) {
        this._matchCriteria.push(value);
    }
    addProperty(key, value) {
        this._properties[key] = value;
    }
}
exports.Connection = Connection;
_a = JSII_RTTI_SYMBOL_1;
Connection[_a] = { fqn: "cdk-extensions.glue.Connection", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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