import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { CfnCrawler } from 'aws-cdk-lib/aws-glue';
import { Role } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { Database } from './database';
import { SecurityConfiguration } from './security-configuration';
export declare enum ConfigurationVersion {
    V1_0 = 1
}
export declare enum DeleteBehavior {
    DELETE_FROM_DATABASE = "DELETE_FROM_DATABASE",
    DEPRECATE_IN_DATABASE = "DEPRECATE_IN_DATABASE",
    LOG = "LOG"
}
export declare enum PartitionUpdateBehavior {
    INHERIT_FROM_TABLE = "InheritFromTable"
}
export declare enum RecrawlBehavior {
    EVENT_MODE = "CRAWL_EVENT_MODE",
    EVERYTHING = "CRAWL_EVERYTHING",
    NEW_FOLDERS_ONLY = "CRAWL_NEW_FOLDERS_ONLY"
}
export declare enum TableGroupingPolicy {
    COMBINE_COMPATIBLE_SCHEMAS = "CombineCompatibleSchemas"
}
export declare enum TableUpdateBehavior {
    MERGE_NEW_COLUMNS = "MergeNewColumns"
}
export declare enum UpdateBehavior {
    UPDATE_IN_DATABASE = "UPDATE_IN_DATABASE",
    LOG = "LOG"
}
export interface CrawlerConfiguration {
    readonly partitionUpdateBehavior?: PartitionUpdateBehavior;
    readonly tableGroupingPolicy?: TableGroupingPolicy;
    readonly tableLevel?: number;
    readonly tableUpdateBehavior?: TableUpdateBehavior;
    readonly version?: ConfigurationVersion;
}
export interface CrawlerTargetCollection {
    readonly catalogTargets?: CfnCrawler.CatalogTargetProperty[];
    readonly dynamoDbTargets?: CfnCrawler.DynamoDBTargetProperty[];
    readonly jdbcTargets?: CfnCrawler.JdbcTargetProperty[];
    readonly s3Targets?: CfnCrawler.S3TargetProperty[];
}
export interface ICrawlerTarget {
    bind(crawler: Crawler): CrawlerTargetCollection;
}
/**
 * Configuration for Crawlner
 */
export interface CrawlerProps extends ResourceProps {
    readonly classifiers?: string[];
    readonly configuration?: CrawlerConfiguration;
    readonly database?: Database;
    readonly deleteBehavior?: DeleteBehavior;
    readonly description?: string;
    readonly name?: string;
    readonly recrawlBehavior?: RecrawlBehavior;
    readonly securityConfiguration?: SecurityConfiguration;
    readonly scheduleExpression?: Schedule;
    readonly tablePrefix?: string;
    readonly targets?: ICrawlerTarget[];
    readonly updateBehavior?: UpdateBehavior;
}
export declare class Crawler extends Resource {
    private readonly _classifiers;
    private readonly _targets;
    readonly configuration?: CrawlerConfiguration;
    readonly database?: Database;
    readonly deleteBehavior?: DeleteBehavior;
    readonly description?: string;
    readonly name?: string;
    readonly recrawlBehavior?: RecrawlBehavior;
    readonly scheduleExpression?: Schedule;
    readonly securityConfiguration?: SecurityConfiguration;
    readonly tablePrefix?: string;
    readonly updateBehavior?: UpdateBehavior;
    readonly role: Role;
    readonly resource: CfnCrawler;
    readonly crawlerArn: string;
    readonly crawlerName: string;
    /**
       * Creates a new instance of the Crawler class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props: CrawlerProps);
    addClassifier(classifier: string): void;
    addTarget(target: ICrawlerTarget): void;
    private renderConfiguration;
    private renderTargets;
}
