export declare class GlueVersion {
    /**
       * Glue version using Spark 2.2.1 and Python 2.7
       */
    static readonly V0_9: GlueVersion;
    /**
       * Glue version using Spark 2.4.3, Python 2.7 and Python 3.6
       */
    static readonly V1_0: GlueVersion;
    /**
       * Glue version using Spark 2.4.3 and Python 3.7
       */
    static readonly V2_0: GlueVersion;
    /**
       * Glue version using Spark 3.1.1 and Python 3.7
       */
    static readonly V3_0: GlueVersion;
    /**
       * Custom Glue version
       * @param version custom version
       */
    static of(version: string): GlueVersion;
    /**
       * The name of this GlueVersion, as expected by Job resource.
       */
    readonly name: string;
    private constructor();
}
