"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class GlueVersion {
    constructor(name) {
        this.name = name;
    }
    /**
       * Custom Glue version
       * @param version custom version
       */
    static of(version) {
        return new GlueVersion(version);
    }
}
exports.GlueVersion = GlueVersion;
_a = JSII_RTTI_SYMBOL_1;
GlueVersion[_a] = { fqn: "cdk-extensions.glue.GlueVersion", version: "0.0.20" };
/**
   * Glue version using Spark 2.2.1 and Python 2.7
   */
GlueVersion.V0_9 = new GlueVersion('0.9');
/**
   * Glue version using Spark 2.4.3, Python 2.7 and Python 3.6
   */
GlueVersion.V1_0 = new GlueVersion('1.0');
/**
   * Glue version using Spark 2.4.3 and Python 3.7
   */
GlueVersion.V2_0 = new GlueVersion('2.0');
/**
   * Glue version using Spark 3.1.1 and Python 3.7
   */
GlueVersion.V3_0 = new GlueVersion('3.0');
//# sourceMappingURL=data:application/json;base64,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