import { Connection } from '../../connection';
import { Crawler, CrawlerTargetCollection, ICrawlerTarget } from '../../crawler';
/**
 * Configuration for Crawler JDBC target
 */
export interface JdbcTargetOptions {
    readonly exclusions?: string[];
    readonly paths?: string[];
}
export declare class JdbcTarget implements ICrawlerTarget {
    private readonly _exclusions;
    private readonly _paths;
    readonly connection: Connection;
    constructor(connection: Connection, options: JdbcTargetOptions);
    addExclusion(exclusion: string): void;
    addPath(path: string): void;
    bind(_crawler: Crawler): CrawlerTargetCollection;
}
