"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkerType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The type of predefined worker that is allocated when a job runs.
 *
 * If you need to use a WorkerType that doesn't exist as a static member, you
 * can instantiate a `WorkerType` object, e.g: `WorkerType.of('other type')`.
 */
class WorkerType {
    constructor(name) {
        this.name = name;
    }
    /**
       * Custom worker type
       *
       * @param workerType custom worker type
       */
    static of(workerType) {
        return new WorkerType(workerType);
    }
}
exports.WorkerType = WorkerType;
_a = JSII_RTTI_SYMBOL_1;
WorkerType[_a] = { fqn: "cdk-extensions.glue.WorkerType", version: "0.0.20" };
/**
   * Each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
   */
WorkerType.STANDARD = new WorkerType('Standard');
/**
   * Each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker. Suitable for memory-intensive jobs.
   */
WorkerType.G_1X = new WorkerType('G.1X');
/**
   * Each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker. Suitable for memory-intensive jobs.
   */
WorkerType.G_2X = new WorkerType('G.2X');
//# sourceMappingURL=data:application/json;base64,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