import { Duration, Resource, ResourceProps } from 'aws-cdk-lib';
import { CfnTable } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
import { Database } from './database';
import { Column } from './lib/column';
import { DataFormat } from './lib/data-format';
export declare enum TableType {
    EXTERNAL_TABLE = "EXTERNAL_TABLE",
    VIRTUAL_VIEW = "VIRTUAL_VIEW"
}
/**
 * Configuration for Table
 */
export interface TableProps extends ResourceProps {
    readonly columns?: Column[];
    readonly compressed?: boolean;
    readonly dataFormat?: DataFormat;
    readonly database: Database;
    readonly description?: string;
    readonly location?: string;
    readonly name?: string;
    readonly owner?: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly partitionKeys?: Column[];
    readonly retention?: Duration;
    readonly serdeName?: string;
    readonly serdeParameters?: {
        [key: string]: string;
    };
    readonly storageParameters?: {
        [key: string]: string;
    };
    readonly storedAsSubDirectories?: boolean;
    readonly tableType?: TableType;
    readonly targetTable?: Table;
    readonly viewExpandedText?: string;
    readonly viewOriginalText?: string;
}
export declare class Table extends Resource {
    private readonly _columns;
    private readonly _parameters;
    private readonly _partitionKeys;
    private readonly _serdeParameters;
    private readonly _storageParameters;
    readonly compressed?: boolean;
    readonly dataFormat?: DataFormat;
    readonly database: Database;
    readonly description?: string;
    readonly location?: string;
    readonly name?: string;
    readonly owner?: string;
    readonly retention?: Duration;
    readonly serdeName?: string;
    readonly tableType?: TableType;
    readonly targetTable?: Table;
    readonly viewExpandedText?: string;
    readonly viewOriginalText?: string;
    readonly storedAsSubDirectories?: boolean;
    readonly resource: CfnTable;
    readonly tableArn: string;
    readonly tableName: string;
    /**
       * Creates a new instance of the Table class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props: TableProps);
    addColumn(column: Column): void;
    addParameter(key: string, value: string): void;
    addPartitionKey(column: Column): void;
    addSerdeParameter(key: string, value: string): void;
    addStorageParameter(key: string, value: string): void;
    protected renderStorageDescriptor(): CfnTable.StorageDescriptorProperty | undefined;
}
