import { Resource, ResourceProps } from 'aws-cdk-lib';
import { Schedule } from 'aws-cdk-lib/aws-events';
import { CfnTrigger } from 'aws-cdk-lib/aws-glue';
import { Construct } from 'constructs';
import { Workflow } from './workflow';
export declare enum PredicateOperator {
    AND = "AND",
    OR = "OR"
}
export declare enum TriggerType {
    CONDITIONAL = "CONDITIONAL",
    EVENT = "EVENT",
    ON_DEMAND = "ON_DEMAND",
    SCHEDULED = "SCHEDULED"
}
export interface ITriggerAction {
    bind(trigger: Trigger): CfnTrigger.ActionProperty;
}
export interface ITriggerPredicate {
    bind(trigger: Trigger): CfnTrigger.ConditionProperty;
}
/**
 * Configuration for the Glue Trigger resource.
 */
export interface TriggerProps extends ResourceProps {
    readonly actions?: ITriggerAction[];
    readonly description?: string;
    readonly name?: string;
    readonly predicateConditions?: ITriggerPredicate[];
    readonly predicateOperator?: PredicateOperator;
    readonly schedule?: Schedule;
    readonly startOnCreation?: boolean;
    readonly type: TriggerType;
    readonly workflow?: Workflow;
}
export declare class Trigger extends Resource {
    private readonly _actions;
    private readonly _predicates;
    readonly description?: string;
    readonly name?: string;
    readonly predicateOperator: PredicateOperator;
    readonly schedule?: Schedule;
    readonly startOnCreation?: boolean;
    readonly type: TriggerType;
    readonly workflow?: Workflow;
    readonly resource: CfnTrigger;
    readonly workflowArn: string;
    readonly workflowName: string;
    constructor(scope: Construct, id: string, props: TriggerProps);
    addAction(action: ITriggerAction): Trigger;
    addPredicate(predicate: ITriggerPredicate): Trigger;
}
