"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Trigger = exports.TriggerType = exports.PredicateOperator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
var PredicateOperator;
(function (PredicateOperator) {
    PredicateOperator["AND"] = "AND";
    PredicateOperator["OR"] = "OR";
})(PredicateOperator = exports.PredicateOperator || (exports.PredicateOperator = {}));
var TriggerType;
(function (TriggerType) {
    TriggerType["CONDITIONAL"] = "CONDITIONAL";
    TriggerType["EVENT"] = "EVENT";
    TriggerType["ON_DEMAND"] = "ON_DEMAND";
    TriggerType["SCHEDULED"] = "SCHEDULED";
})(TriggerType = exports.TriggerType || (exports.TriggerType = {}));
class Trigger extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._actions = [];
        this._predicates = [];
        this.description = props.description;
        this.name = props.name;
        this.predicateOperator = props.predicateOperator ?? PredicateOperator.AND;
        this.schedule = props.schedule;
        this.startOnCreation = props.startOnCreation ?? (props.type === TriggerType.ON_DEMAND ? false : true);
        this.type = props.type;
        this.workflow = props.workflow;
        props.actions?.forEach((x) => {
            this.addAction(x);
        });
        props.predicateConditions?.forEach((x) => {
            this.addPredicate(x);
        });
        this.resource = new aws_glue_1.CfnTrigger(this, 'Resource', {
            actions: aws_cdk_lib_1.Lazy.uncachedAny({
                produce: () => {
                    return this._actions.map((x) => {
                        return x.bind(this);
                    });
                },
            }, {
                omitEmptyArray: true,
            }),
            description: this.description,
            name: this.name,
            predicate: aws_cdk_lib_1.Lazy.uncachedAny({
                produce: () => {
                    return !!!this._predicates.length ? undefined : {
                        conditions: this._predicates.map((x) => {
                            return x.bind(this);
                        }),
                        logical: this._predicates.length > 1 ? this.predicateOperator : undefined,
                    };
                },
            }),
            schedule: this.schedule?.expressionString,
            startOnCreation: this.startOnCreation,
            type: this.type,
            workflowName: this.workflow?.workflowName,
        });
        this.workflowArn = this.stack.formatArn({
            resource: 'table',
            resourceName: this.resource.ref,
            service: 'glue',
        });
        this.workflowName = this.resource.ref;
    }
    addAction(action) {
        this._actions.push(action);
        return this;
    }
    addPredicate(predicate) {
        this._predicates.push(predicate);
        return this;
    }
}
exports.Trigger = Trigger;
_a = JSII_RTTI_SYMBOL_1;
Trigger[_a] = { fqn: "cdk-extensions.glue.Trigger", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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