import { IResource, Resource, ResourceProps } from 'aws-cdk-lib';
import { Metric, MetricOptions } from 'aws-cdk-lib/aws-cloudwatch';
import { Connections, IConnectable } from 'aws-cdk-lib/aws-ec2';
import { Grant, IGrantable, IPrincipal, IRole } from 'aws-cdk-lib/aws-iam';
import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { Construct } from 'constructs';
import { DeliveryStreamDestination } from './lib/destinations/delivery-stream-destination';
export declare enum DeliveryStreamType {
    DIRECT_PUT = "DirectPut",
    KINESIS_STREAM_AS_SOURCE = "KinesisStreamAsSource"
}
export interface IDeliveryStream extends IResource, IGrantable, IConnectable {
    readonly deliveryStreamArn: string;
    readonly deliveryStreamName: string;
    grant(grantee: IGrantable, ...actions: string[]): Grant;
    grantPutRecords(grantee: IGrantable): Grant;
    metric(metricName: string, props?: MetricOptions): Metric;
    metricBackupToS3Bytes(props?: MetricOptions): Metric;
    metricBackupToS3DataFreshness(props?: MetricOptions): Metric;
    metricBackupToS3Records(props?: MetricOptions): Metric;
    metricIncomingBytes(props?: MetricOptions): Metric;
    metricIncomingRecords(props?: MetricOptions): Metric;
}
declare abstract class DeliveryStreamBase extends Resource implements IDeliveryStream {
    abstract readonly deliveryStreamName: string;
    abstract readonly deliveryStreamArn: string;
    abstract readonly grantPrincipal: IPrincipal;
    readonly connections: Connections;
    constructor(scope: Construct, id: string, props?: ResourceProps);
    grant(grantee: IGrantable, ...actions: string[]): Grant;
    grantPutRecords(grantee: IGrantable): Grant;
    metric(metricName: string, props?: MetricOptions): Metric;
    metricBackupToS3Bytes(props?: MetricOptions): Metric;
    metricBackupToS3DataFreshness(props?: MetricOptions): Metric;
    metricBackupToS3Records(props?: MetricOptions): Metric;
    metricIncomingBytes(props?: MetricOptions): Metric;
    metricIncomingRecords(props?: MetricOptions): Metric;
}
export interface DeliveryStreamAttributes {
    readonly deliveryStreamArn?: string;
    readonly deliveryStreamName?: string;
    readonly role?: IRole;
}
export interface DeliveryStreamProps extends ResourceProps {
    readonly destination: DeliveryStreamDestination;
    readonly name?: string;
    readonly streamType?: DeliveryStreamType;
}
export declare class DeliveryStream extends DeliveryStreamBase {
    static fromDeliveryStreamArn(scope: Construct, id: string, deliveryStreamArn: string): IDeliveryStream;
    static fromDeliveryStreamAttributes(scope: Construct, id: string, attrs: DeliveryStreamAttributes): IDeliveryStream;
    static fromDeliveryStreamName(scope: Construct, id: string, deliveryStreamName: string): IDeliveryStream;
    readonly destination: DeliveryStreamDestination;
    readonly name?: string;
    readonly streamType?: DeliveryStreamType;
    readonly resource: CfnDeliveryStream;
    readonly deliveryStreamArn: string;
    readonly deliveryStreamName: string;
    readonly grantPrincipal: IPrincipal;
    constructor(scope: Construct, id: string, props: DeliveryStreamProps);
}
export {};
