"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeliveryStream = exports.DeliveryStreamType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_kinesisfirehose_1 = require("aws-cdk-lib/aws-kinesisfirehose");
const region_info_1 = require("aws-cdk-lib/region-info");
var DeliveryStreamType;
(function (DeliveryStreamType) {
    DeliveryStreamType["DIRECT_PUT"] = "DirectPut";
    DeliveryStreamType["KINESIS_STREAM_AS_SOURCE"] = "KinesisStreamAsSource";
})(DeliveryStreamType = exports.DeliveryStreamType || (exports.DeliveryStreamType = {}));
class DeliveryStreamBase extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        const mappingId = '@aws-cdk/aws-kinesisfirehose.CidrBlocks';
        const mapping = this.node.tryFindChild(mappingId) ?? new aws_cdk_lib_1.CfnMapping(this, mappingId, {
            lazy: true,
            mapping: region_info_1.RegionInfo.regions.reduce((prev, cur) => {
                if (cur.firehoseCidrBlock) {
                    prev[cur.name] = {
                        FirehoseCidrBlock: cur.firehoseCidrBlock,
                    };
                }
                return prev;
            }, {}),
        });
        this.connections = new aws_ec2_1.Connections({
            peer: aws_ec2_1.Peer.ipv4(mapping.findInMap(this.stack.region, 'FirehoseCidrBlock')),
        });
    }
    grant(grantee, ...actions) {
        return aws_iam_1.Grant.addToPrincipal({
            resourceArns: [
                this.deliveryStreamArn,
            ],
            grantee: grantee,
            actions: actions,
        });
    }
    grantPutRecords(grantee) {
        return this.grant(grantee, ...[
            'firehose:PutRecord',
            'firehose:PutRecordBatch',
        ]);
    }
    metric(metricName, props) {
        return new aws_cloudwatch_1.Metric({
            dimensionsMap: {
                DeliveryStreamName: this.deliveryStreamName,
            },
            metricName: metricName,
            namespace: 'AWS/Firehose',
            ...props,
        }).attachTo(this);
    }
    metricBackupToS3Bytes(props) {
        return this.metric('BackupToS3.Bytes', {
            statistic: 'Sum',
            ...props,
        });
    }
    metricBackupToS3DataFreshness(props) {
        return this.metric('BackupToS3.DataFreshness', {
            statistic: 'Average',
            ...props,
        });
    }
    metricBackupToS3Records(props) {
        return this.metric('BackupToS3.Records', {
            statistic: 'Sum',
            ...props,
        });
    }
    metricIncomingBytes(props) {
        return this.metric('IncomingBytes', {
            statistic: 'Sum',
            ...props,
        });
    }
    metricIncomingRecords(props) {
        return this.metric('IncomingRecords', {
            statistic: 'Sum',
            ...props,
        });
    }
}
class DeliveryStream extends DeliveryStreamBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.destination = props.destination;
        this.name = props.name;
        this.streamType = props.streamType;
        const resolvedDestination = this.destination.bind(this);
        this.resource = new aws_kinesisfirehose_1.CfnDeliveryStream(this, 'Resource', {
            ...resolvedDestination,
            deliveryStreamName: this.name,
            deliveryStreamType: this.streamType,
        });
        this.deliveryStreamArn = this.resource.attrArn;
        this.deliveryStreamName = this.resource.ref;
        this.grantPrincipal = this.destination.role ?? new aws_iam_1.UnknownPrincipal({
            resource: this,
        });
    }
    static fromDeliveryStreamArn(scope, id, deliveryStreamArn) {
        return DeliveryStream.fromDeliveryStreamAttributes(scope, id, {
            deliveryStreamArn: deliveryStreamArn,
        });
    }
    static fromDeliveryStreamAttributes(scope, id, attrs) {
        if (!attrs.deliveryStreamArn && !attrs.deliveryStreamName) {
            throw new Error('Must specify at least one of deliveryStreamArn or deliveryStreamName when importing a delivery stream.');
        }
        const deliveryStreamArn = attrs.deliveryStreamArn ?? aws_cdk_lib_1.Stack.of(scope).formatArn({
            resource: 'deliverystream',
            resourceName: attrs.deliveryStreamName,
            service: 'firehose',
        });
        const intrinsitName = aws_cdk_lib_1.Fn.select(1, aws_cdk_lib_1.Fn.split('/', deliveryStreamArn));
        const parsedName = !aws_cdk_lib_1.Token.isUnresolved(deliveryStreamArn) ?
            aws_cdk_lib_1.Stack.of(scope).splitArn(deliveryStreamArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName :
            intrinsitName;
        const deliveryStreamName = attrs.deliveryStreamName ?? parsedName ?? intrinsitName;
        class Import extends DeliveryStreamBase {
            constructor() {
                super(...arguments);
                this.deliveryStreamArn = deliveryStreamArn;
                this.deliveryStreamName = deliveryStreamName;
                this.grantPrincipal = attrs.role ?? new aws_iam_1.UnknownPrincipal({
                    resource: this,
                });
            }
        }
        return new Import(scope, id);
    }
    static fromDeliveryStreamName(scope, id, deliveryStreamName) {
        return DeliveryStream.fromDeliveryStreamAttributes(scope, id, {
            deliveryStreamName: deliveryStreamName,
        });
    }
}
exports.DeliveryStream = DeliveryStream;
_a = JSII_RTTI_SYMBOL_1;
DeliveryStream[_a] = { fqn: "cdk-extensions.kinesis_firehose.DeliveryStream", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVsaXZlcnktc3RyZWFtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2tpbmVzaXMtZmlyZWhvc2UvZGVsaXZlcnktc3RyZWFtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQTBHO0FBQzFHLCtEQUFtRTtBQUNuRSxpREFBc0U7QUFDdEUsaURBQTZGO0FBQzdGLHlFQUFvRTtBQUNwRSx5REFBcUQ7QUFLckQsSUFBWSxrQkFHWDtBQUhELFdBQVksa0JBQWtCO0lBQzVCLDhDQUF3QixDQUFBO0lBQ3hCLHdFQUFrRCxDQUFBO0FBQ3BELENBQUMsRUFIVyxrQkFBa0IsR0FBbEIsMEJBQWtCLEtBQWxCLDBCQUFrQixRQUc3QjtBQWVELE1BQWUsa0JBQW1CLFNBQVEsc0JBQVE7SUFPaEQsWUFBbUIsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBdUIsRUFBRTtRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4QixNQUFNLFNBQVMsR0FBRyx5Q0FBeUMsQ0FBQztRQUM1RCxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQWUsSUFBSSxJQUFJLHdCQUFVLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUNqRyxJQUFJLEVBQUUsSUFBSTtZQUNWLE9BQU8sRUFBRSx3QkFBVSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLEVBQUUsR0FBRyxFQUFFLEVBQUU7Z0JBQy9DLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFO29CQUN6QixJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHO3dCQUNmLGlCQUFpQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUI7cUJBQ3pDLENBQUM7aUJBQ0g7Z0JBQ0QsT0FBTyxJQUFJLENBQUM7WUFDZCxDQUFDLEVBQUUsRUFBa0QsQ0FBQztTQUN2RCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUkscUJBQVcsQ0FBQztZQUNqQyxJQUFJLEVBQUUsY0FBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFFLG1CQUFtQixDQUFDLENBQUM7U0FDM0UsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLEtBQUssQ0FBQyxPQUFtQixFQUFFLEdBQUcsT0FBaUI7UUFDcEQsT0FBTyxlQUFLLENBQUMsY0FBYyxDQUFDO1lBQzFCLFlBQVksRUFBRTtnQkFDWixJQUFJLENBQUMsaUJBQWlCO2FBQ3ZCO1lBQ0QsT0FBTyxFQUFFLE9BQU87WUFDaEIsT0FBTyxFQUFFLE9BQU87U0FDakIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLGVBQWUsQ0FBQyxPQUFtQjtRQUN4QyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLEdBQUc7WUFDNUIsb0JBQW9CO1lBQ3BCLHlCQUF5QjtTQUMxQixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sTUFBTSxDQUFDLFVBQWtCLEVBQUUsS0FBcUI7UUFDckQsT0FBTyxJQUFJLHVCQUFNLENBQUM7WUFDaEIsYUFBYSxFQUFFO2dCQUNiLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7YUFDNUM7WUFDRCxVQUFVLEVBQUUsVUFBVTtZQUN0QixTQUFTLEVBQUUsY0FBYztZQUN6QixHQUFHLEtBQUs7U0FDVCxDQUFDLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3BCLENBQUM7SUFFTSxxQkFBcUIsQ0FBQyxLQUFxQjtRQUNoRCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsa0JBQWtCLEVBQUU7WUFDckMsU0FBUyxFQUFFLEtBQUs7WUFDaEIsR0FBRyxLQUFLO1NBQ1QsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLDZCQUE2QixDQUFDLEtBQXFCO1FBQ3hELE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQywwQkFBMEIsRUFBRTtZQUM3QyxTQUFTLEVBQUUsU0FBUztZQUNwQixHQUFHLEtBQUs7U0FDVCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0sdUJBQXVCLENBQUMsS0FBcUI7UUFDbEQsT0FBTyxJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQixFQUFFO1lBQ3ZDLFNBQVMsRUFBRSxLQUFLO1lBQ2hCLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxtQkFBbUIsQ0FBQyxLQUFxQjtRQUM5QyxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxFQUFFO1lBQ2xDLFNBQVMsRUFBRSxLQUFLO1lBQ2hCLEdBQUcsS0FBSztTQUNULENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxxQkFBcUIsQ0FBQyxLQUFxQjtRQUNoRCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsaUJBQWlCLEVBQUU7WUFDcEMsU0FBUyxFQUFFLEtBQUs7WUFDaEIsR0FBRyxLQUFLO1NBQ1QsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBY0QsTUFBYSxjQUFlLFNBQVEsa0JBQWtCO0lBdURwRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztRQUNyQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7UUFDdkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUMsVUFBVSxDQUFDO1FBRW5DLE1BQU0sbUJBQW1CLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFeEQsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLHVDQUFpQixDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDdEQsR0FBRyxtQkFBbUI7WUFDdEIsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLElBQUk7WUFDN0Isa0JBQWtCLEVBQUUsSUFBSSxDQUFDLFVBQVU7U0FDcEMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDO1FBQy9DLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQztRQUU1QyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxJQUFJLElBQUksMEJBQWdCLENBQUM7WUFDbEUsUUFBUSxFQUFFLElBQUk7U0FDZixDQUFDLENBQUM7SUFDTCxDQUFDO0lBM0VNLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxpQkFBeUI7UUFDekYsT0FBTyxjQUFjLENBQUMsNEJBQTRCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUM1RCxpQkFBaUIsRUFBRSxpQkFBaUI7U0FDckMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUErQjtRQUN0RyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFrQixFQUFFO1lBQ3pELE1BQU0sSUFBSSxLQUFLLENBQUMsd0dBQXdHLENBQUMsQ0FBQztTQUMzSDtRQUVELE1BQU0saUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixJQUFJLG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsQ0FBQztZQUM3RSxRQUFRLEVBQUUsZ0JBQWdCO1lBQzFCLFlBQVksRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQ3RDLE9BQU8sRUFBRSxVQUFVO1NBQ3BCLENBQUMsQ0FBQztRQUVILE1BQU0sYUFBYSxHQUFHLGdCQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxnQkFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO1FBQ3JFLE1BQU0sVUFBVSxHQUFHLENBQUMsbUJBQUssQ0FBQyxZQUFZLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxDQUFDO1lBQ3pELG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVEsQ0FBQyxpQkFBaUIsRUFBRSx1QkFBUyxDQUFDLG1CQUFtQixDQUFDLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDekYsYUFBYSxDQUFDO1FBQ2hCLE1BQU0sa0JBQWtCLEdBQUcsS0FBSyxDQUFDLGtCQUFrQixJQUFJLFVBQVUsSUFBSSxhQUFhLENBQUM7UUFFbkYsTUFBTSxNQUFPLFNBQVEsa0JBQWtCO1lBQXZDOztnQkFDa0Isc0JBQWlCLEdBQVcsaUJBQWlCLENBQUM7Z0JBQzlDLHVCQUFrQixHQUFXLGtCQUFrQixDQUFDO2dCQUNoRCxtQkFBYyxHQUFlLEtBQUssQ0FBQyxJQUFJLElBQUksSUFBSSwwQkFBZ0IsQ0FBQztvQkFDOUUsUUFBUSxFQUFFLElBQUk7aUJBQ2YsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztTQUFBO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQUVNLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxrQkFBMEI7UUFDM0YsT0FBTyxjQUFjLENBQUMsNEJBQTRCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUM1RCxrQkFBa0IsRUFBRSxrQkFBa0I7U0FDdkMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF2Q0gsd0NBNkVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXJuRm9ybWF0LCBDZm5NYXBwaW5nLCBGbiwgSVJlc291cmNlLCBSZXNvdXJjZSwgUmVzb3VyY2VQcm9wcywgU3RhY2ssIFRva2VuIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgTWV0cmljLCBNZXRyaWNPcHRpb25zIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2gnO1xuaW1wb3J0IHsgQ29ubmVjdGlvbnMsIElDb25uZWN0YWJsZSwgUGVlciB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0IHsgR3JhbnQsIElHcmFudGFibGUsIElQcmluY2lwYWwsIElSb2xlLCBVbmtub3duUHJpbmNpcGFsIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBDZm5EZWxpdmVyeVN0cmVhbSB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1raW5lc2lzZmlyZWhvc2UnO1xuaW1wb3J0IHsgUmVnaW9uSW5mbyB9IGZyb20gJ2F3cy1jZGstbGliL3JlZ2lvbi1pbmZvJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgRGVsaXZlcnlTdHJlYW1EZXN0aW5hdGlvbiB9IGZyb20gJy4vbGliL2Rlc3RpbmF0aW9ucy9kZWxpdmVyeS1zdHJlYW0tZGVzdGluYXRpb24nO1xuXG5cbmV4cG9ydCBlbnVtIERlbGl2ZXJ5U3RyZWFtVHlwZSB7XG4gIERJUkVDVF9QVVQgPSAnRGlyZWN0UHV0JyxcbiAgS0lORVNJU19TVFJFQU1fQVNfU09VUkNFID0gJ0tpbmVzaXNTdHJlYW1Bc1NvdXJjZSdcbn1cblxuZXhwb3J0IGludGVyZmFjZSBJRGVsaXZlcnlTdHJlYW0gZXh0ZW5kcyBJUmVzb3VyY2UsIElHcmFudGFibGUsIElDb25uZWN0YWJsZSB7XG4gIHJlYWRvbmx5IGRlbGl2ZXJ5U3RyZWFtQXJuOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlbGl2ZXJ5U3RyZWFtTmFtZTogc3RyaW5nO1xuICBncmFudChncmFudGVlOiBJR3JhbnRhYmxlLCAuLi5hY3Rpb25zOiBzdHJpbmdbXSk6IEdyYW50O1xuICBncmFudFB1dFJlY29yZHMoZ3JhbnRlZTogSUdyYW50YWJsZSk6IEdyYW50O1xuICBtZXRyaWMobWV0cmljTmFtZTogc3RyaW5nLCBwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWM7XG4gIG1ldHJpY0JhY2t1cFRvUzNCeXRlcyhwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWM7XG4gIG1ldHJpY0JhY2t1cFRvUzNEYXRhRnJlc2huZXNzKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYztcbiAgbWV0cmljQmFja3VwVG9TM1JlY29yZHMocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljO1xuICBtZXRyaWNJbmNvbWluZ0J5dGVzKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYztcbiAgbWV0cmljSW5jb21pbmdSZWNvcmRzKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYztcbn1cblxuYWJzdHJhY3QgY2xhc3MgRGVsaXZlcnlTdHJlYW1CYXNlIGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJRGVsaXZlcnlTdHJlYW0ge1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZGVsaXZlcnlTdHJlYW1OYW1lOiBzdHJpbmc7XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBkZWxpdmVyeVN0cmVhbUFybjogc3RyaW5nO1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZ3JhbnRQcmluY2lwYWw6IElQcmluY2lwYWw7XG5cbiAgcHVibGljIHJlYWRvbmx5IGNvbm5lY3Rpb25zOiBDb25uZWN0aW9ucztcblxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJlc291cmNlUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgY29uc3QgbWFwcGluZ0lkID0gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzZmlyZWhvc2UuQ2lkckJsb2Nrcyc7XG4gICAgY29uc3QgbWFwcGluZyA9IHRoaXMubm9kZS50cnlGaW5kQ2hpbGQobWFwcGluZ0lkKSBhcyBDZm5NYXBwaW5nID8/IG5ldyBDZm5NYXBwaW5nKHRoaXMsIG1hcHBpbmdJZCwge1xuICAgICAgbGF6eTogdHJ1ZSxcbiAgICAgIG1hcHBpbmc6IFJlZ2lvbkluZm8ucmVnaW9ucy5yZWR1Y2UoKHByZXYsIGN1cikgPT4ge1xuICAgICAgICBpZiAoY3VyLmZpcmVob3NlQ2lkckJsb2NrKSB7XG4gICAgICAgICAgcHJldltjdXIubmFtZV0gPSB7XG4gICAgICAgICAgICBGaXJlaG9zZUNpZHJCbG9jazogY3VyLmZpcmVob3NlQ2lkckJsb2NrLFxuICAgICAgICAgIH07XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHByZXY7XG4gICAgICB9LCB7fSBhcyB7W2tleTogc3RyaW5nXToge0ZpcmVob3NlQ2lkckJsb2NrOiBzdHJpbmd9fSksXG4gICAgfSk7XG5cbiAgICB0aGlzLmNvbm5lY3Rpb25zID0gbmV3IENvbm5lY3Rpb25zKHtcbiAgICAgIHBlZXI6IFBlZXIuaXB2NChtYXBwaW5nLmZpbmRJbk1hcCh0aGlzLnN0YWNrLnJlZ2lvbiwgJ0ZpcmVob3NlQ2lkckJsb2NrJykpLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGdyYW50KGdyYW50ZWU6IElHcmFudGFibGUsIC4uLmFjdGlvbnM6IHN0cmluZ1tdKTogR3JhbnQge1xuICAgIHJldHVybiBHcmFudC5hZGRUb1ByaW5jaXBhbCh7XG4gICAgICByZXNvdXJjZUFybnM6IFtcbiAgICAgICAgdGhpcy5kZWxpdmVyeVN0cmVhbUFybixcbiAgICAgIF0sXG4gICAgICBncmFudGVlOiBncmFudGVlLFxuICAgICAgYWN0aW9uczogYWN0aW9ucyxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudFB1dFJlY29yZHMoZ3JhbnRlZTogSUdyYW50YWJsZSk6IEdyYW50IHtcbiAgICByZXR1cm4gdGhpcy5ncmFudChncmFudGVlLCAuLi5bXG4gICAgICAnZmlyZWhvc2U6UHV0UmVjb3JkJyxcbiAgICAgICdmaXJlaG9zZTpQdXRSZWNvcmRCYXRjaCcsXG4gICAgXSk7XG4gIH1cblxuICBwdWJsaWMgbWV0cmljKG1ldHJpY05hbWU6IHN0cmluZywgcHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gbmV3IE1ldHJpYyh7XG4gICAgICBkaW1lbnNpb25zTWFwOiB7XG4gICAgICAgIERlbGl2ZXJ5U3RyZWFtTmFtZTogdGhpcy5kZWxpdmVyeVN0cmVhbU5hbWUsXG4gICAgICB9LFxuICAgICAgbWV0cmljTmFtZTogbWV0cmljTmFtZSxcbiAgICAgIG5hbWVzcGFjZTogJ0FXUy9GaXJlaG9zZScsXG4gICAgICAuLi5wcm9wcyxcbiAgICB9KS5hdHRhY2hUbyh0aGlzKTtcbiAgfVxuXG4gIHB1YmxpYyBtZXRyaWNCYWNrdXBUb1MzQnl0ZXMocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0JhY2t1cFRvUzMuQnl0ZXMnLCB7XG4gICAgICBzdGF0aXN0aWM6ICdTdW0nLFxuICAgICAgLi4ucHJvcHMsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgbWV0cmljQmFja3VwVG9TM0RhdGFGcmVzaG5lc3MocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0JhY2t1cFRvUzMuRGF0YUZyZXNobmVzcycsIHtcbiAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgICAgLi4ucHJvcHMsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgbWV0cmljQmFja3VwVG9TM1JlY29yZHMocHJvcHM/OiBNZXRyaWNPcHRpb25zKTogTWV0cmljIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWMoJ0JhY2t1cFRvUzMuUmVjb3JkcycsIHtcbiAgICAgIHN0YXRpc3RpYzogJ1N1bScsXG4gICAgICAuLi5wcm9wcyxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBtZXRyaWNJbmNvbWluZ0J5dGVzKHByb3BzPzogTWV0cmljT3B0aW9ucyk6IE1ldHJpYyB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljKCdJbmNvbWluZ0J5dGVzJywge1xuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIG1ldHJpY0luY29taW5nUmVjb3Jkcyhwcm9wcz86IE1ldHJpY09wdGlvbnMpOiBNZXRyaWMge1xuICAgIHJldHVybiB0aGlzLm1ldHJpYygnSW5jb21pbmdSZWNvcmRzJywge1xuICAgICAgc3RhdGlzdGljOiAnU3VtJyxcbiAgICAgIC4uLnByb3BzLFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGVsaXZlcnlTdHJlYW1BdHRyaWJ1dGVzIHtcbiAgcmVhZG9ubHkgZGVsaXZlcnlTdHJlYW1Bcm4/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGRlbGl2ZXJ5U3RyZWFtTmFtZT86IHN0cmluZztcbiAgcmVhZG9ubHkgcm9sZT86IElSb2xlO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERlbGl2ZXJ5U3RyZWFtUHJvcHMgZXh0ZW5kcyBSZXNvdXJjZVByb3BzIHtcbiAgcmVhZG9ubHkgZGVzdGluYXRpb246IERlbGl2ZXJ5U3RyZWFtRGVzdGluYXRpb247XG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHN0cmVhbVR5cGU/OiBEZWxpdmVyeVN0cmVhbVR5cGU7XG59XG5cbmV4cG9ydCBjbGFzcyBEZWxpdmVyeVN0cmVhbSBleHRlbmRzIERlbGl2ZXJ5U3RyZWFtQmFzZSB7XG4gIHB1YmxpYyBzdGF0aWMgZnJvbURlbGl2ZXJ5U3RyZWFtQXJuKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGRlbGl2ZXJ5U3RyZWFtQXJuOiBzdHJpbmcpOiBJRGVsaXZlcnlTdHJlYW0ge1xuICAgIHJldHVybiBEZWxpdmVyeVN0cmVhbS5mcm9tRGVsaXZlcnlTdHJlYW1BdHRyaWJ1dGVzKHNjb3BlLCBpZCwge1xuICAgICAgZGVsaXZlcnlTdHJlYW1Bcm46IGRlbGl2ZXJ5U3RyZWFtQXJuLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIHN0YXRpYyBmcm9tRGVsaXZlcnlTdHJlYW1BdHRyaWJ1dGVzKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGF0dHJzOiBEZWxpdmVyeVN0cmVhbUF0dHJpYnV0ZXMpOiBJRGVsaXZlcnlTdHJlYW0ge1xuICAgIGlmICghYXR0cnMuZGVsaXZlcnlTdHJlYW1Bcm4gJiYgIWF0dHJzLmRlbGl2ZXJ5U3RyZWFtTmFtZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdNdXN0IHNwZWNpZnkgYXQgbGVhc3Qgb25lIG9mIGRlbGl2ZXJ5U3RyZWFtQXJuIG9yIGRlbGl2ZXJ5U3RyZWFtTmFtZSB3aGVuIGltcG9ydGluZyBhIGRlbGl2ZXJ5IHN0cmVhbS4nKTtcbiAgICB9XG5cbiAgICBjb25zdCBkZWxpdmVyeVN0cmVhbUFybiA9IGF0dHJzLmRlbGl2ZXJ5U3RyZWFtQXJuID8/IFN0YWNrLm9mKHNjb3BlKS5mb3JtYXRBcm4oe1xuICAgICAgcmVzb3VyY2U6ICdkZWxpdmVyeXN0cmVhbScsXG4gICAgICByZXNvdXJjZU5hbWU6IGF0dHJzLmRlbGl2ZXJ5U3RyZWFtTmFtZSxcbiAgICAgIHNlcnZpY2U6ICdmaXJlaG9zZScsXG4gICAgfSk7XG5cbiAgICBjb25zdCBpbnRyaW5zaXROYW1lID0gRm4uc2VsZWN0KDEsIEZuLnNwbGl0KCcvJywgZGVsaXZlcnlTdHJlYW1Bcm4pKTtcbiAgICBjb25zdCBwYXJzZWROYW1lID0gIVRva2VuLmlzVW5yZXNvbHZlZChkZWxpdmVyeVN0cmVhbUFybikgP1xuICAgICAgU3RhY2sub2Yoc2NvcGUpLnNwbGl0QXJuKGRlbGl2ZXJ5U3RyZWFtQXJuLCBBcm5Gb3JtYXQuU0xBU0hfUkVTT1VSQ0VfTkFNRSkucmVzb3VyY2VOYW1lIDpcbiAgICAgIGludHJpbnNpdE5hbWU7XG4gICAgY29uc3QgZGVsaXZlcnlTdHJlYW1OYW1lID0gYXR0cnMuZGVsaXZlcnlTdHJlYW1OYW1lID8/IHBhcnNlZE5hbWUgPz8gaW50cmluc2l0TmFtZTtcblxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIERlbGl2ZXJ5U3RyZWFtQmFzZSB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZGVsaXZlcnlTdHJlYW1Bcm46IHN0cmluZyA9IGRlbGl2ZXJ5U3RyZWFtQXJuO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGRlbGl2ZXJ5U3RyZWFtTmFtZTogc3RyaW5nID0gZGVsaXZlcnlTdHJlYW1OYW1lO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGdyYW50UHJpbmNpcGFsOiBJUHJpbmNpcGFsID0gYXR0cnMucm9sZSA/PyBuZXcgVW5rbm93blByaW5jaXBhbCh7XG4gICAgICAgIHJlc291cmNlOiB0aGlzLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyBzdGF0aWMgZnJvbURlbGl2ZXJ5U3RyZWFtTmFtZShzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBkZWxpdmVyeVN0cmVhbU5hbWU6IHN0cmluZyk6IElEZWxpdmVyeVN0cmVhbSB7XG4gICAgcmV0dXJuIERlbGl2ZXJ5U3RyZWFtLmZyb21EZWxpdmVyeVN0cmVhbUF0dHJpYnV0ZXMoc2NvcGUsIGlkLCB7XG4gICAgICBkZWxpdmVyeVN0cmVhbU5hbWU6IGRlbGl2ZXJ5U3RyZWFtTmFtZSxcbiAgICB9KTtcbiAgfVxuXG4gIC8vIElucHV0IHByb3BlcnRpZXNcbiAgcHVibGljIHJlYWRvbmx5IGRlc3RpbmF0aW9uOiBEZWxpdmVyeVN0cmVhbURlc3RpbmF0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgbmFtZT86IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHN0cmVhbVR5cGU/OiBEZWxpdmVyeVN0cmVhbVR5cGU7XG5cbiAgLy8gUmVzb3VyY2UgcHJvcGVydGllc1xuICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2U6IENmbkRlbGl2ZXJ5U3RyZWFtO1xuXG4gIC8vIFN0YW5kYXJkIHByb3BlcnRpZXNcbiAgcHVibGljIHJlYWRvbmx5IGRlbGl2ZXJ5U3RyZWFtQXJuOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBkZWxpdmVyeVN0cmVhbU5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGdyYW50UHJpbmNpcGFsOiBJUHJpbmNpcGFsO1xuXG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERlbGl2ZXJ5U3RyZWFtUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIHRoaXMuZGVzdGluYXRpb24gPSBwcm9wcy5kZXN0aW5hdGlvbjtcbiAgICB0aGlzLm5hbWUgPSBwcm9wcy5uYW1lO1xuICAgIHRoaXMuc3RyZWFtVHlwZSA9IHByb3BzLnN0cmVhbVR5cGU7XG5cbiAgICBjb25zdCByZXNvbHZlZERlc3RpbmF0aW9uID0gdGhpcy5kZXN0aW5hdGlvbi5iaW5kKHRoaXMpO1xuXG4gICAgdGhpcy5yZXNvdXJjZSA9IG5ldyBDZm5EZWxpdmVyeVN0cmVhbSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAuLi5yZXNvbHZlZERlc3RpbmF0aW9uLFxuICAgICAgZGVsaXZlcnlTdHJlYW1OYW1lOiB0aGlzLm5hbWUsXG4gICAgICBkZWxpdmVyeVN0cmVhbVR5cGU6IHRoaXMuc3RyZWFtVHlwZSxcbiAgICB9KTtcblxuICAgIHRoaXMuZGVsaXZlcnlTdHJlYW1Bcm4gPSB0aGlzLnJlc291cmNlLmF0dHJBcm47XG4gICAgdGhpcy5kZWxpdmVyeVN0cmVhbU5hbWUgPSB0aGlzLnJlc291cmNlLnJlZjtcblxuICAgIHRoaXMuZ3JhbnRQcmluY2lwYWwgPSB0aGlzLmRlc3RpbmF0aW9uLnJvbGUgPz8gbmV3IFVua25vd25QcmluY2lwYWwoe1xuICAgICAgcmVzb3VyY2U6IHRoaXMsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==