import { CfnDeliveryStream } from 'aws-cdk-lib/aws-kinesisfirehose';
import { IConstruct } from 'constructs';
export interface BackupConfigurationResult {
    readonly s3BackupConfiguration: CfnDeliveryStream.S3DestinationConfigurationProperty;
    readonly s3BackupMode?: string;
}
export interface IDeliveryStreamBackupDestination {
    renderBackupConfiguration(scope: IConstruct, enabled?: boolean): BackupConfigurationResult;
}
export interface BackupConfigurationOptions {
    readonly destination: IDeliveryStreamBackupDestination;
    readonly enabled?: boolean;
}
export declare class BackupConfiguration {
    readonly destination: IDeliveryStreamBackupDestination;
    readonly enabled?: boolean;
    constructor(options: BackupConfigurationOptions);
    bind(scope: IConstruct): BackupConfigurationResult;
}
