"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExtendedS3Destination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const formatting_1 = require("../../../utils/formatting");
const s3_destination_1 = require("./s3-destination");
class ExtendedS3Destination extends s3_destination_1.S3Destination {
    constructor(bucket, options = {}) {
        super(bucket, options);
        this._processors = [];
        this.backupConfiguration = options.backupConfiguration;
        this.dataFormatConversion = options.dataFormatConversion;
        this.dynamicPartitioning = options.dynamicPartitioning;
        this.processorConfiguration = options.processorConfiguration;
    }
    // Internal accessors
    get processingEnabled() {
        return this._processingEnabled ?? !!this._processors?.length;
    }
    get processors() {
        return [...this._processors];
    }
    addProcessor(processor) {
        this._processors.push(processor);
        return this;
    }
    bind(scope) {
        const processorConfiguration = this.processorConfiguration?.bind(scope);
        this._processingEnabled = processorConfiguration?.enabled;
        processorConfiguration?.processors.forEach((x) => {
            this.addProcessor(x);
        });
        const dynamicPartitioningConfiguration = this.dynamicPartitioning?.bind(scope);
        const dataFormatConversion = this.dataFormatConversion?.bind(scope);
        dynamicPartitioningConfiguration?.processors?.forEach((x) => {
            this.addProcessor(x);
        });
        if (dynamicPartitioningConfiguration?.partitioningConfiguration.enabled && (this.buffering?.sizeInMb ?? 64) < 64) {
            throw new Error('When dynamic partitioning is enabled buffer size must be at least 64MB.');
        }
        return {
            extendedS3DestinationConfiguration: {
                ...this.buildConfiguration(scope),
                ...(this.backupConfiguration?.bind(scope) ?? {}),
                dataFormatConversionConfiguration: dataFormatConversion,
                dynamicPartitioningConfiguration: dynamicPartitioningConfiguration?.partitioningConfiguration,
                processingConfiguration: aws_cdk_lib_1.Lazy.any({
                    produce: () => {
                        return this.renderProcessorConfiguration(scope);
                    },
                }),
            },
        };
    }
    renderProcessorConfiguration(scope) {
        return formatting_1.definedFieldsOrUndefined({
            enabled: this.processingEnabled,
            processors: this._processors.map((x) => {
                return x.bind(scope);
            }),
        });
    }
}
exports.ExtendedS3Destination = ExtendedS3Destination;
_a = JSII_RTTI_SYMBOL_1;
ExtendedS3Destination[_a] = { fqn: "cdk-extensions.kinesis_firehose.ExtendedS3Destination", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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