"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonQuery = exports.MetaDataExtractionQuery = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class MetaDataExtractionQuery {
    constructor(query) {
        this.query = query;
    }
    static jq(fields) {
        return new JsonQuery(fields);
    }
    static of(query) {
        return new MetaDataExtractionQuery(query);
    }
    render() {
        return this.query;
    }
}
exports.MetaDataExtractionQuery = MetaDataExtractionQuery;
_a = JSII_RTTI_SYMBOL_1;
MetaDataExtractionQuery[_a] = { fqn: "cdk-extensions.kinesis_firehose.MetaDataExtractionQuery", version: "0.0.20" };
class JsonQuery extends MetaDataExtractionQuery {
    constructor(fields) {
        super(aws_cdk_lib_1.Lazy.string({
            produce: () => {
                const collapsed = Object.keys(this.fields).map((x) => {
                    return `${x}: ${this.fields[x]}`;
                }).join(', ');
                return `{${collapsed}}`;
            },
        }));
        this.fields = {};
        if (fields) {
            Object.keys(fields).forEach((x) => {
                this.addField(x, fields[x]);
            });
        }
    }
    addField(name, query) {
        this.fields[name] = query;
        return this;
    }
}
exports.JsonQuery = JsonQuery;
_b = JSII_RTTI_SYMBOL_1;
JsonQuery[_b] = { fqn: "cdk-extensions.kinesis_firehose.JsonQuery", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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