import { DeliveryStreamProcessor } from './delivery-stream-processor';
export declare class SubRecordType {
    static readonly DELIMITED: SubRecordType;
    static readonly JSON: SubRecordType;
    static of(name: string): SubRecordType;
    readonly name: string;
    private constructor();
}
export interface DelimitedDeaggregationOptions {
    readonly delimiter: string;
}
export interface RecordDeaggregationProcessorOptions {
    readonly delimiter?: string;
    readonly subRecordType: SubRecordType;
}
export declare class RecordDeaggregationProcessor extends DeliveryStreamProcessor {
    static delimited(options: DelimitedDeaggregationOptions): RecordDeaggregationProcessor;
    static json(): RecordDeaggregationProcessor;
    readonly delimiter?: string;
    readonly subRecordType: SubRecordType;
    constructor(options: RecordDeaggregationProcessorOptions);
}
