"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecordDeaggregationProcessor = exports.SubRecordType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const delivery_stream_processor_1 = require("./delivery-stream-processor");
class SubRecordType {
    constructor(name) {
        this.name = name;
    }
    static of(name) {
        return new SubRecordType(name);
    }
}
exports.SubRecordType = SubRecordType;
_a = JSII_RTTI_SYMBOL_1;
SubRecordType[_a] = { fqn: "cdk-extensions.kinesis_firehose.SubRecordType", version: "0.0.20" };
SubRecordType.DELIMITED = SubRecordType.of('DELIMITED');
SubRecordType.JSON = SubRecordType.of('JSON');
class RecordDeaggregationProcessor extends delivery_stream_processor_1.DeliveryStreamProcessor {
    constructor(options) {
        super({
            processorType: delivery_stream_processor_1.ProcessorType.RECORD_DEAGGREGATION,
        });
        this.delimiter = options.delimiter;
        this.subRecordType = options.subRecordType;
        this.addProcessorParameter('SubRecordType', this.subRecordType.name);
        if (this.delimiter) {
            this.addProcessorParameter('Delimiter', this.delimiter);
        }
    }
    static delimited(options) {
        return new RecordDeaggregationProcessor({
            subRecordType: SubRecordType.DELIMITED,
            ...options,
        });
    }
    static json() {
        return new RecordDeaggregationProcessor({
            subRecordType: SubRecordType.JSON,
        });
    }
}
exports.RecordDeaggregationProcessor = RecordDeaggregationProcessor;
_b = JSII_RTTI_SYMBOL_1;
RecordDeaggregationProcessor[_b] = { fqn: "cdk-extensions.kinesis_firehose.RecordDeaggregationProcessor", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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