import { IProject } from 'aws-cdk-lib/aws-codebuild';
import { ISubnet } from 'aws-cdk-lib/aws-ec2';
import { IConstruct } from 'constructs';
export interface ISharedResource {
    bind(scope: IConstruct): string;
}
export declare class SharedResource implements ISharedResource {
    static fromArn(arn: string): SharedResource;
    static fromProject(project: IProject): SharedResource;
    static fromSubnet(subnet: ISubnet): SharedResource;
    private readonly arn;
    private constructor();
    bind(_scope: IConstruct): string;
}
