"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class SharedResource {
    constructor(arn) {
        this.arn = arn;
    }
    static fromArn(arn) {
        return new SharedResource(arn);
    }
    static fromProject(project) {
        return new SharedResource(project.projectArn);
    }
    static fromSubnet(subnet) {
        return new SharedResource(subnet.stack.formatArn({
            resource: 'subnet',
            resourceName: subnet.subnetId,
            service: 'ec2',
        }));
    }
    bind(_scope) {
        return this.arn;
    }
}
exports.SharedResource = SharedResource;
_a = JSII_RTTI_SYMBOL_1;
SharedResource[_a] = { fqn: "cdk-extensions.ram.SharedResource", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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