import { Resource, ResourceProps } from 'aws-cdk-lib';
import { CfnResourceShare } from 'aws-cdk-lib/aws-ram';
import { Construct } from 'constructs';
import { ISharedPrincipal } from './lib/shared-principal';
import { ISharedResource } from './lib/shared-resource';
/**
 * Configuration for ResourceShare resource.
 */
export interface ResourceShareProps extends ResourceProps {
    readonly allowExternalPrincipals?: boolean;
    readonly autoDiscoverAccounts?: boolean;
    readonly name?: string;
    readonly principals?: ISharedPrincipal[];
    readonly resources?: ISharedResource[];
}
export declare class ResourceShare extends Resource {
    private _autoDiscovery;
    private readonly _principals;
    private readonly _resources;
    readonly allowExternalPrincipals?: boolean;
    readonly name: string;
    readonly resource: CfnResourceShare;
    get autoDiscovery(): boolean;
    /**
       * Creates a new instance of the ResourceShare class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props?: ResourceShareProps);
    addPrincipal(principal: ISharedPrincipal): void;
    addResource(resource: ISharedResource): void;
    private autoDiscover;
    enableAutoDiscovery(): void;
}
