"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceShare = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ram_1 = require("aws-cdk-lib/aws-ram");
const shared_principal_1 = require("./lib/shared-principal");
class ResourceShare extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the ResourceShare class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        // Internal properties
        this._autoDiscovery = false;
        this._principals = [];
        this._resources = [];
        this.allowExternalPrincipals = props.allowExternalPrincipals;
        this.name = props.name ?? aws_cdk_lib_1.Names.uniqueId(this);
        this.resource = new aws_ram_1.CfnResourceShare(this, 'Resource', {
            allowExternalPrincipals: this.allowExternalPrincipals,
            name: this.name,
            principals: aws_cdk_lib_1.Lazy.uncachedList({
                produce: () => {
                    return this._principals.map((x) => {
                        return x.bind(this);
                    });
                },
            }),
            resourceArns: aws_cdk_lib_1.Lazy.uncachedList({
                produce: () => {
                    return this._resources.map((x) => {
                        return x.bind(this);
                    });
                },
            }),
        });
    }
    // Standard accessors
    get autoDiscovery() {
        return this._autoDiscovery;
    }
    addPrincipal(principal) {
        this._principals.push(principal);
    }
    addResource(resource) {
        this._resources.push(resource);
    }
    autoDiscover() {
        const accounts = new Set(this.node.root.node.findAll().reduce((prev, cur) => {
            if (cur instanceof aws_cdk_lib_1.Stage && cur.account && !aws_cdk_lib_1.Token.isUnresolved(cur.account)) {
                prev.push(cur.account);
            }
            else if (cur instanceof aws_cdk_lib_1.Stack && !aws_cdk_lib_1.Token.isUnresolved(cur.account)) {
                prev.push(cur.account);
            }
            return prev;
        }, []).filter((x) => {
            return x !== this.stack.account;
        }));
        accounts.forEach((x) => {
            this.addPrincipal(shared_principal_1.SharedPrincipal.fromAccountId(x));
        });
    }
    enableAutoDiscovery() {
        if (!this.autoDiscovery) {
            aws_cdk_lib_1.Aspects.of(this).add({
                visit: (node) => {
                    if (node === this) {
                        this.autoDiscover();
                    }
                },
            });
            this._autoDiscovery = true;
        }
    }
}
exports.ResourceShare = ResourceShare;
_a = JSII_RTTI_SYMBOL_1;
ResourceShare[_a] = { fqn: "cdk-extensions.ram.ResourceShare", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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