import { ResourceProps } from 'aws-cdk-lib';
import { IVpc, SubnetSelection } from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
import { ResolverEndpointBase } from './resolver-endpoint-base';
/**
 * Configuration for the Inbound Resolver resource.
 */
export interface InboundResolverProps extends ResourceProps {
    /**
       * A list of CIDR ranges that the Inbound Resolver allows to connect to it to make DNS queries.
       *
       * @default InboundResolver.DEFAULT_INBOUND_CIDRS
       */
    readonly inboundCidrs?: string[];
    /**
       * The selection criteria to use to determine which subnets in a VPC resolver endpoints should be
       * created in. As a matter of best practice, at least 3 subnets in different availablity zones should
       * be used.
       */
    readonly subnets: SubnetSelection;
    /**
       * The VPC where the resolver endpoints should be created.
       */
    readonly vpc: IVpc;
}
export declare class InboundResolver extends ResolverEndpointBase {
    static readonly DEFAULT_INBOUND_CIDRS: string[];
    static readonly DIRECTION: string;
    static readonly SUBNET_OFFSET: number;
    readonly inboundCidrs: string[];
    /**
       * Creates a new instance of the InboundResolver class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props: InboundResolverProps);
}
