"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolverRuleAssociation = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_route53resolver_1 = require("aws-cdk-lib/aws-route53resolver");
class ResolverRuleAssociation extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the ResolverRule class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.name = props.name;
        this.resolverRule = props.resolverRule;
        this.vpc = props.vpc;
        this.resource = new aws_route53resolver_1.CfnResolverRuleAssociation(this, 'Resource', {
            name: this.name,
            resolverRuleId: this.resolverRule.resolverRuleId,
            vpcId: this.vpc.vpcId,
        });
        this.resolverRuleAssociationId = this.resource.attrResolverRuleAssociationId;
        this.resolverRuleAssociationName = this.resource.attrName;
        this.resolverRuleAssociationResolverRuleId = this.resource.attrResolverRuleId;
        this.resolverRuleAssociationVpcId = this.resource.attrVpcId;
    }
}
exports.ResolverRuleAssociation = ResolverRuleAssociation;
//# sourceMappingURL=data:application/json;base64,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