"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudtrailBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const glue_1 = require("../glue");
const glue_tables_1 = require("../glue-tables");
const raw_bucket_1 = require("./private/raw-bucket");
class CloudtrailBucket extends raw_bucket_1.RawBucket {
    /**
       * Creates a new instance of the CloudtrailBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            bucketEncryption: {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            sseAlgorithm: 'AES256',
                        },
                    },
                ],
            },
            bucketName: props.bucketName ?? aws_cdk_lib_1.PhysicalName.GENERATE_IF_NEEDED,
            publicAccessBlockConfiguration: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
            versioningConfiguration: {
                status: 'Enabled',
            },
        });
        this.createQueries = props.createQueries;
        this.friendlyQueryNames = props.friendlyQueryNames;
        this.database = props.database ?? new glue_1.Database(this, 'database', {
            description: 'Database for storing CloudTrail information',
        });
        this.table = new glue_tables_1.CloudtrailTable(this, 'table', {
            bucket: this,
            createQueries: this.createQueries,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            name: props.tableName,
        });
    }
}
exports.CloudtrailBucket = CloudtrailBucket;
_a = JSII_RTTI_SYMBOL_1;
CloudtrailBucket[_a] = { fqn: "cdk-extensions.s3_buckets.CloudtrailBucket", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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