import { Resource } from 'aws-cdk-lib';
import { Rule } from 'aws-cdk-lib/aws-events';
import { AddToResourcePolicyResult, Grant, IGrantable, PolicyStatement } from 'aws-cdk-lib/aws-iam';
import { IKey } from 'aws-cdk-lib/aws-kms';
import { BucketPolicy, CfnBucket, CfnBucketProps, EventType, IBucket, IBucketNotificationDestination, NotificationKeyFilter, OnCloudTrailBucketEventOptions, TransferAccelerationUrlOptions, VirtualHostedStyleUrlOptions } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Configuration for objects bucket
 */
export interface RawBucketProps extends CfnBucketProps {
}
/**
 * Do not use directly. Will be removed once a better replacemnt is written.
 */
export declare class RawBucket extends Resource implements IBucket {
    private readonly _cdkBucket;
    policy?: BucketPolicy;
    readonly resource: CfnBucket;
    readonly bucketArn: string;
    readonly bucketName: string;
    readonly bucketWebsiteUrl: string;
    readonly bucketWebsiteDomainName: string;
    readonly bucketDomainName: string;
    readonly bucketDualStackDomainName: string;
    readonly bucketRegionalDomainName: string;
    readonly encryptionKey?: IKey | undefined;
    readonly isWebsite?: boolean | undefined;
    /**
       * Creates a new instance of the ReplicatedBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props?: RawBucketProps);
    urlForObject(_key?: string): string;
    transferAccelerationUrlForObject(_key?: string, _options?: TransferAccelerationUrlOptions): string;
    virtualHostedUrlForObject(_key?: string, _options?: VirtualHostedStyleUrlOptions): string;
    s3UrlForObject(_key?: string): string;
    arnForObjects(_keyPattern: string): string;
    grantRead(_identity: IGrantable, _objectsKeyPattern?: any): Grant;
    grantWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant;
    grantPut(_identity: IGrantable, _objectsKeyPattern?: any): Grant;
    grantPutAcl(_identity: IGrantable, _objectsKeyPattern?: string): Grant;
    grantDelete(_identity: IGrantable, _objectsKeyPattern?: any): Grant;
    grantReadWrite(_identity: IGrantable, _objectsKeyPattern?: any): Grant;
    grantPublicAccess(_keyPrefix?: string, ..._allowedActions: string[]): Grant;
    onCloudTrailEvent(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule;
    onCloudTrailPutObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule;
    onCloudTrailWriteObject(_id: string, _options?: OnCloudTrailBucketEventOptions): Rule;
    addEventNotification(_event: EventType, _dest: IBucketNotificationDestination, ..._filters: NotificationKeyFilter[]): void;
    addObjectCreatedNotification(_dest: IBucketNotificationDestination, ..._filters: NotificationKeyFilter[]): void;
    addObjectRemovedNotification(_dest: IBucketNotificationDestination, ..._filters: NotificationKeyFilter[]): void;
    enableEventBridgeNotification(): void;
    addToResourcePolicy(permission: PolicyStatement): AddToResourcePolicyResult;
}
