"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RawBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const lazy_1 = require("../../utils/lazy");
/**
 * Do not use directly. Will be removed once a better replacemnt is written.
 */
class RawBucket extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the ReplicatedBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.bucketName,
        });
        this.resource = new aws_s3_1.CfnBucket(this, 'Resource', {
            ...props,
            bucketName: this.physicalName,
        });
        this.resource.applyRemovalPolicy(aws_cdk_lib_1.RemovalPolicy.RETAIN);
        this.bucketArn = this.getResourceArnAttribute(this.resource.attrArn, {
            account: '',
            region: '',
            resource: this.physicalName,
            service: 's3',
        });
        this.bucketName = this.getResourceNameAttribute(this.resource.ref);
        this.bucketRegionalDomainName = lazy_1.contextAwareString(this, this.resource.attrRegionalDomainName, `${this.bucketName}.s3.${this.stack.region}.amazonaws.com`);
        this._cdkBucket = aws_s3_1.Bucket.fromBucketAttributes(this, 'cdk-bucket', {
            account: this.stack.account,
            bucketArn: this.bucketArn,
            bucketDomainName: this.resource.attrDomainName,
            bucketDualStackDomainName: this.resource.attrDualStackDomainName,
            bucketName: this.bucketName,
            bucketRegionalDomainName: this.resource.attrRegionalDomainName,
            bucketWebsiteUrl: this.resource.attrWebsiteUrl,
            region: this.stack.region,
        });
        this.bucketWebsiteUrl = this._cdkBucket.bucketWebsiteUrl;
        this.bucketWebsiteDomainName = this._cdkBucket.bucketWebsiteDomainName;
        this.bucketDomainName = this._cdkBucket.bucketDomainName;
        this.bucketDualStackDomainName = this._cdkBucket.bucketDualStackDomainName;
        this.isWebsite = this._cdkBucket.isWebsite;
        this.encryptionKey = this._cdkBucket.encryptionKey;
        this.addEventNotification = this._cdkBucket.addEventNotification;
        this.addObjectCreatedNotification = this._cdkBucket.addObjectCreatedNotification;
        this.addObjectRemovedNotification = this._cdkBucket.addObjectRemovedNotification;
        this.arnForObjects = this._cdkBucket.arnForObjects;
        this.enableEventBridgeNotification = this._cdkBucket.enableEventBridgeNotification;
        this.grantDelete = this._cdkBucket.grantDelete;
        this.grantPublicAccess = this._cdkBucket.grantPublicAccess;
        this.grantPut = this._cdkBucket.grantPut;
        this.grantPutAcl = this._cdkBucket.grantPutAcl;
        this.grantRead = this._cdkBucket.grantRead;
        this.grantReadWrite = this._cdkBucket.grantReadWrite;
        this.grantWrite = this._cdkBucket.grantWrite;
        this.onCloudTrailEvent = this._cdkBucket.onCloudTrailEvent;
        this.onCloudTrailPutObject = this._cdkBucket.onCloudTrailPutObject;
        this.onCloudTrailWriteObject = this._cdkBucket.onCloudTrailWriteObject;
        this.s3UrlForObject = this._cdkBucket.s3UrlForObject;
        this.transferAccelerationUrlForObject = this._cdkBucket.transferAccelerationUrlForObject;
        this.urlForObject = this._cdkBucket.urlForObject;
        this.virtualHostedUrlForObject = this._cdkBucket.virtualHostedUrlForObject;
    }
    urlForObject(_key) {
        throw new Error('Method not implemented.');
    }
    transferAccelerationUrlForObject(_key, _options) {
        throw new Error('Method not implemented.');
    }
    virtualHostedUrlForObject(_key, _options) {
        throw new Error('Method not implemented.');
    }
    s3UrlForObject(_key) {
        throw new Error('Method not implemented.');
    }
    arnForObjects(_keyPattern) {
        throw new Error('Method not implemented.');
    }
    grantRead(_identity, _objectsKeyPattern) {
        throw new Error('Method not implemented.');
    }
    grantWrite(_identity, _objectsKeyPattern) {
        throw new Error('Method not implemented.');
    }
    grantPut(_identity, _objectsKeyPattern) {
        throw new Error('Method not implemented.');
    }
    grantPutAcl(_identity, _objectsKeyPattern) {
        throw new Error('Method not implemented.');
    }
    grantDelete(_identity, _objectsKeyPattern) {
        throw new Error('Method not implemented.');
    }
    grantReadWrite(_identity, _objectsKeyPattern) {
        throw new Error('Method not implemented.');
    }
    grantPublicAccess(_keyPrefix, ..._allowedActions) {
        throw new Error('Method not implemented.');
    }
    onCloudTrailEvent(_id, _options) {
        throw new Error('Method not implemented.');
    }
    onCloudTrailPutObject(_id, _options) {
        throw new Error('Method not implemented.');
    }
    onCloudTrailWriteObject(_id, _options) {
        throw new Error('Method not implemented.');
    }
    addEventNotification(_event, _dest, ..._filters) {
        throw new Error('Method not implemented.');
    }
    addObjectCreatedNotification(_dest, ..._filters) {
        throw new Error('Method not implemented.');
    }
    addObjectRemovedNotification(_dest, ..._filters) {
        throw new Error('Method not implemented.');
    }
    enableEventBridgeNotification() {
        throw new Error('Method not implemented.');
    }
    addToResourcePolicy(permission) {
        const policy = this.policy ?? new aws_s3_1.BucketPolicy(this, 'policy', {
            bucket: this,
        });
        this.policy = policy;
        policy.document.addStatements(permission);
        return {
            statementAdded: true,
            policyDependable: this.policy,
        };
    }
}
exports.RawBucket = RawBucket;
_a = JSII_RTTI_SYMBOL_1;
RawBucket[_a] = { fqn: "cdk-extensions.s3_buckets.RawBucket", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmF3LWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9zMy1idWNrZXRzL3ByaXZhdGUvcmF3LWJ1Y2tldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUFzRDtBQUl0RCwrQ0FBOFA7QUFFOVAsMkNBQXNEO0FBUXREOztHQUVHO0FBQ0gsTUFBYSxTQUFVLFNBQVEsc0JBQVE7SUFvQnJDOzs7Ozs7O1NBT0s7SUFDTCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLFFBQXdCLEVBQUU7UUFDbEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixZQUFZLEVBQUUsS0FBSyxDQUFDLFVBQVU7U0FDL0IsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLGtCQUFTLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM5QyxHQUFHLEtBQUs7WUFDUixVQUFVLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDOUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsQ0FBQywyQkFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBRXZELElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxFQUFFO1lBQ25FLE9BQU8sRUFBRSxFQUFFO1lBQ1gsTUFBTSxFQUFFLEVBQUU7WUFDVixRQUFRLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDM0IsT0FBTyxFQUFFLElBQUk7U0FDZCxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ25FLElBQUksQ0FBQyx3QkFBd0IsR0FBRyx5QkFBa0IsQ0FDaEQsSUFBSSxFQUNKLElBQUksQ0FBQyxRQUFRLENBQUMsc0JBQXNCLEVBQ3BDLEdBQUcsSUFBSSxDQUFDLFVBQVUsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU0sZ0JBQWdCLENBQzNELENBQUM7UUFHRixJQUFJLENBQUMsVUFBVSxHQUFHLGVBQU0sQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEVBQUUsWUFBWSxFQUFFO1lBQ2hFLE9BQU8sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87WUFDM0IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYztZQUM5Qyx5QkFBeUIsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLHVCQUF1QjtZQUNoRSxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0Isd0JBQXdCLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxzQkFBc0I7WUFDOUQsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxjQUFjO1lBQzlDLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE1BQU07U0FDMUIsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekQsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDdkUsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUM7UUFDekQsSUFBSSxDQUFDLHlCQUF5QixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUM7UUFDM0UsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzQyxJQUFJLENBQUMsYUFBYSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBRW5ELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLG9CQUFvQixDQUFDO1FBQ2pFLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLDRCQUE0QixDQUFDO1FBQ2pGLElBQUksQ0FBQyw0QkFBNEIsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLDRCQUE0QixDQUFDO1FBQ2pGLElBQUksQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUM7UUFDbkQsSUFBSSxDQUFDLDZCQUE2QixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsNkJBQTZCLENBQUM7UUFDbkYsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUMvQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQztRQUMzRCxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUM7UUFDL0MsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQztRQUMzQyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1FBQ3JELElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0MsSUFBSSxDQUFDLGlCQUFpQixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUM7UUFDM0QsSUFBSSxDQUFDLHFCQUFxQixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMscUJBQXFCLENBQUM7UUFDbkUsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDdkUsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLGNBQWMsQ0FBQztRQUNyRCxJQUFJLENBQUMsZ0NBQWdDLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxnQ0FBZ0MsQ0FBQztRQUN6RixJQUFJLENBQUMsWUFBWSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ2pELElBQUksQ0FBQyx5QkFBeUIsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDO0lBQzdFLENBQUM7SUFFTSxZQUFZLENBQUMsSUFBYTtRQUMvQixNQUFNLElBQUksS0FBSyxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVNLGdDQUFnQyxDQUFDLElBQWEsRUFBRSxRQUF5QztRQUM5RixNQUFNLElBQUksS0FBSyxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVNLHlCQUF5QixDQUFDLElBQWEsRUFBRSxRQUF1QztRQUNyRixNQUFNLElBQUksS0FBSyxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVNLGNBQWMsQ0FBQyxJQUFhO1FBQ2pDLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sYUFBYSxDQUFDLFdBQW1CO1FBQ3RDLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sU0FBUyxDQUFDLFNBQXFCLEVBQUUsa0JBQXdCO1FBQzlELE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sVUFBVSxDQUFDLFNBQXFCLEVBQUUsa0JBQXdCO1FBQy9ELE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sUUFBUSxDQUFDLFNBQXFCLEVBQUUsa0JBQXdCO1FBQzdELE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sV0FBVyxDQUFDLFNBQXFCLEVBQUUsa0JBQTJCO1FBQ25FLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sV0FBVyxDQUFDLFNBQXFCLEVBQUUsa0JBQXdCO1FBQ2hFLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sY0FBYyxDQUFDLFNBQXFCLEVBQUUsa0JBQXdCO1FBQ25FLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0saUJBQWlCLENBQUMsVUFBbUIsRUFBRSxHQUFHLGVBQXlCO1FBQ3hFLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0saUJBQWlCLENBQUMsR0FBVyxFQUFFLFFBQXlDO1FBQzdFLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0scUJBQXFCLENBQUMsR0FBVyxFQUFFLFFBQXlDO1FBQ2pGLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sdUJBQXVCLENBQUMsR0FBVyxFQUFFLFFBQXlDO1FBQ25GLE1BQU0sSUFBSSxLQUFLLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRU0sb0JBQW9CLENBQUMsTUFBaUIsRUFBRSxLQUFxQyxFQUFFLEdBQUcsUUFBaUM7UUFDeEgsTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFTSw0QkFBNEIsQ0FBQyxLQUFxQyxFQUFFLEdBQUcsUUFBaUM7UUFDN0csTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFTSw0QkFBNEIsQ0FBQyxLQUFxQyxFQUFFLEdBQUcsUUFBaUM7UUFDN0csTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFTSw2QkFBNkI7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFTSxtQkFBbUIsQ0FBQyxVQUEyQjtRQUNwRCxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxJQUFJLElBQUkscUJBQVksQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFO1lBQzdELE1BQU0sRUFBRSxJQUFJO1NBQ2IsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUM7UUFFckIsTUFBTSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDMUMsT0FBTztZQUNMLGNBQWMsRUFBRSxJQUFJO1lBQ3BCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxNQUFNO1NBQzlCLENBQUM7SUFDSixDQUFDOztBQW5MSCw4QkFvTEMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBSZW1vdmFsUG9saWN5LCBSZXNvdXJjZSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IFJ1bGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtZXZlbnRzJztcbmltcG9ydCB7IEFkZFRvUmVzb3VyY2VQb2xpY3lSZXN1bHQsIEdyYW50LCBJR3JhbnRhYmxlLCBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCB7IElLZXkgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3Mta21zJztcbmltcG9ydCB7IEJ1Y2tldCwgQnVja2V0UG9saWN5LCBDZm5CdWNrZXQsIENmbkJ1Y2tldFByb3BzLCBFdmVudFR5cGUsIElCdWNrZXQsIElCdWNrZXROb3RpZmljYXRpb25EZXN0aW5hdGlvbiwgTm90aWZpY2F0aW9uS2V5RmlsdGVyLCBPbkNsb3VkVHJhaWxCdWNrZXRFdmVudE9wdGlvbnMsIFRyYW5zZmVyQWNjZWxlcmF0aW9uVXJsT3B0aW9ucywgVmlydHVhbEhvc3RlZFN0eWxlVXJsT3B0aW9ucyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zMyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IGNvbnRleHRBd2FyZVN0cmluZyB9IGZyb20gJy4uLy4uL3V0aWxzL2xhenknO1xuXG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBmb3Igb2JqZWN0cyBidWNrZXRcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBSYXdCdWNrZXRQcm9wcyBleHRlbmRzIENmbkJ1Y2tldFByb3BzIHt9XG5cbi8qKlxuICogRG8gbm90IHVzZSBkaXJlY3RseS4gV2lsbCBiZSByZW1vdmVkIG9uY2UgYSBiZXR0ZXIgcmVwbGFjZW1udCBpcyB3cml0dGVuLlxuICovXG5leHBvcnQgY2xhc3MgUmF3QnVja2V0IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJQnVja2V0IHtcbiAgLy8gSW50ZXJuYWwgcHJvcGVydGllc1xuICBwcml2YXRlIHJlYWRvbmx5IF9jZGtCdWNrZXQ6IElCdWNrZXQ7XG5cbiAgLy8gUmVzb3VyY2UgcHJvcGVydGllc1xuICBwdWJsaWMgcG9saWN5PzogQnVja2V0UG9saWN5O1xuICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2U6IENmbkJ1Y2tldDtcblxuICAvLyBJQnVja2V0IHByb3BlcnRpZXNcbiAgcHVibGljIHJlYWRvbmx5IGJ1Y2tldEFybjogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYnVja2V0TmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYnVja2V0V2Vic2l0ZVVybDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYnVja2V0V2Vic2l0ZURvbWFpbk5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGJ1Y2tldERvbWFpbk5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGJ1Y2tldER1YWxTdGFja0RvbWFpbk5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IGJ1Y2tldFJlZ2lvbmFsRG9tYWluTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZW5jcnlwdGlvbktleT86IElLZXkgfCB1bmRlZmluZWQ7XG4gIHB1YmxpYyByZWFkb25seSBpc1dlYnNpdGU/OiBib29sZWFuIHwgdW5kZWZpbmVkO1xuXG5cbiAgLyoqXG4gICAgICogQ3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGUgUmVwbGljYXRlZEJ1Y2tldCBjbGFzcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSBBIENESyBDb25zdHJ1Y3QgdGhhdCB3aWxsIHNlcnZlIGFzIHRoaXMgc3RhY2sncyBwYXJlbnQgaW4gdGhlIGNvbnN0cnVjdCB0cmVlLlxuICAgICAqIEBwYXJhbSBpZCBBIG5hbWUgdG8gYmUgYXNzb2NpYXRlZCB3aXRoIHRoZSBzdGFjayBhbmQgdXNlZCBpbiByZXNvdXJjZSBuYW1pbmcuIE11c3QgYmUgdW5pcXVlXG4gICAgICogd2l0aGluIHRoZSBjb250ZXh0IG9mICdzY29wZScuXG4gICAgICogQHBhcmFtIHByb3BzIEFyZ3VtZW50cyByZWxhdGVkIHRvIHRoZSBjb25maWd1cmF0aW9uIG9mIHRoZSByZXNvdXJjZS5cbiAgICAgKi9cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJhd0J1Y2tldFByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHBoeXNpY2FsTmFtZTogcHJvcHMuYnVja2V0TmFtZSxcbiAgICB9KTtcblxuICAgIHRoaXMucmVzb3VyY2UgPSBuZXcgQ2ZuQnVja2V0KHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgYnVja2V0TmFtZTogdGhpcy5waHlzaWNhbE5hbWUsXG4gICAgfSk7XG4gICAgdGhpcy5yZXNvdXJjZS5hcHBseVJlbW92YWxQb2xpY3koUmVtb3ZhbFBvbGljeS5SRVRBSU4pO1xuXG4gICAgdGhpcy5idWNrZXRBcm4gPSB0aGlzLmdldFJlc291cmNlQXJuQXR0cmlidXRlKHRoaXMucmVzb3VyY2UuYXR0ckFybiwge1xuICAgICAgYWNjb3VudDogJycsXG4gICAgICByZWdpb246ICcnLFxuICAgICAgcmVzb3VyY2U6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgc2VydmljZTogJ3MzJyxcbiAgICB9KTtcbiAgICB0aGlzLmJ1Y2tldE5hbWUgPSB0aGlzLmdldFJlc291cmNlTmFtZUF0dHJpYnV0ZSh0aGlzLnJlc291cmNlLnJlZik7XG4gICAgdGhpcy5idWNrZXRSZWdpb25hbERvbWFpbk5hbWUgPSBjb250ZXh0QXdhcmVTdHJpbmcoXG4gICAgICB0aGlzLFxuICAgICAgdGhpcy5yZXNvdXJjZS5hdHRyUmVnaW9uYWxEb21haW5OYW1lLFxuICAgICAgYCR7dGhpcy5idWNrZXROYW1lfS5zMy4ke3RoaXMuc3RhY2sucmVnaW9ufS5hbWF6b25hd3MuY29tYCwgLy8gVE9ETyAtIGZpbmQgYSBiZXR0ZXIgd2F5IHRvIHJlc29sdmUgdGhlIFRMRFxuICAgICk7XG5cblxuICAgIHRoaXMuX2Nka0J1Y2tldCA9IEJ1Y2tldC5mcm9tQnVja2V0QXR0cmlidXRlcyh0aGlzLCAnY2RrLWJ1Y2tldCcsIHtcbiAgICAgIGFjY291bnQ6IHRoaXMuc3RhY2suYWNjb3VudCxcbiAgICAgIGJ1Y2tldEFybjogdGhpcy5idWNrZXRBcm4sXG4gICAgICBidWNrZXREb21haW5OYW1lOiB0aGlzLnJlc291cmNlLmF0dHJEb21haW5OYW1lLFxuICAgICAgYnVja2V0RHVhbFN0YWNrRG9tYWluTmFtZTogdGhpcy5yZXNvdXJjZS5hdHRyRHVhbFN0YWNrRG9tYWluTmFtZSxcbiAgICAgIGJ1Y2tldE5hbWU6IHRoaXMuYnVja2V0TmFtZSxcbiAgICAgIGJ1Y2tldFJlZ2lvbmFsRG9tYWluTmFtZTogdGhpcy5yZXNvdXJjZS5hdHRyUmVnaW9uYWxEb21haW5OYW1lLFxuICAgICAgYnVja2V0V2Vic2l0ZVVybDogdGhpcy5yZXNvdXJjZS5hdHRyV2Vic2l0ZVVybCxcbiAgICAgIHJlZ2lvbjogdGhpcy5zdGFjay5yZWdpb24sXG4gICAgfSk7XG5cbiAgICB0aGlzLmJ1Y2tldFdlYnNpdGVVcmwgPSB0aGlzLl9jZGtCdWNrZXQuYnVja2V0V2Vic2l0ZVVybDtcbiAgICB0aGlzLmJ1Y2tldFdlYnNpdGVEb21haW5OYW1lID0gdGhpcy5fY2RrQnVja2V0LmJ1Y2tldFdlYnNpdGVEb21haW5OYW1lO1xuICAgIHRoaXMuYnVja2V0RG9tYWluTmFtZSA9IHRoaXMuX2Nka0J1Y2tldC5idWNrZXREb21haW5OYW1lO1xuICAgIHRoaXMuYnVja2V0RHVhbFN0YWNrRG9tYWluTmFtZSA9IHRoaXMuX2Nka0J1Y2tldC5idWNrZXREdWFsU3RhY2tEb21haW5OYW1lO1xuICAgIHRoaXMuaXNXZWJzaXRlID0gdGhpcy5fY2RrQnVja2V0LmlzV2Vic2l0ZTtcbiAgICB0aGlzLmVuY3J5cHRpb25LZXkgPSB0aGlzLl9jZGtCdWNrZXQuZW5jcnlwdGlvbktleTtcblxuICAgIHRoaXMuYWRkRXZlbnROb3RpZmljYXRpb24gPSB0aGlzLl9jZGtCdWNrZXQuYWRkRXZlbnROb3RpZmljYXRpb247XG4gICAgdGhpcy5hZGRPYmplY3RDcmVhdGVkTm90aWZpY2F0aW9uID0gdGhpcy5fY2RrQnVja2V0LmFkZE9iamVjdENyZWF0ZWROb3RpZmljYXRpb247XG4gICAgdGhpcy5hZGRPYmplY3RSZW1vdmVkTm90aWZpY2F0aW9uID0gdGhpcy5fY2RrQnVja2V0LmFkZE9iamVjdFJlbW92ZWROb3RpZmljYXRpb247XG4gICAgdGhpcy5hcm5Gb3JPYmplY3RzID0gdGhpcy5fY2RrQnVja2V0LmFybkZvck9iamVjdHM7XG4gICAgdGhpcy5lbmFibGVFdmVudEJyaWRnZU5vdGlmaWNhdGlvbiA9IHRoaXMuX2Nka0J1Y2tldC5lbmFibGVFdmVudEJyaWRnZU5vdGlmaWNhdGlvbjtcbiAgICB0aGlzLmdyYW50RGVsZXRlID0gdGhpcy5fY2RrQnVja2V0LmdyYW50RGVsZXRlO1xuICAgIHRoaXMuZ3JhbnRQdWJsaWNBY2Nlc3MgPSB0aGlzLl9jZGtCdWNrZXQuZ3JhbnRQdWJsaWNBY2Nlc3M7XG4gICAgdGhpcy5ncmFudFB1dCA9IHRoaXMuX2Nka0J1Y2tldC5ncmFudFB1dDtcbiAgICB0aGlzLmdyYW50UHV0QWNsID0gdGhpcy5fY2RrQnVja2V0LmdyYW50UHV0QWNsO1xuICAgIHRoaXMuZ3JhbnRSZWFkID0gdGhpcy5fY2RrQnVja2V0LmdyYW50UmVhZDtcbiAgICB0aGlzLmdyYW50UmVhZFdyaXRlID0gdGhpcy5fY2RrQnVja2V0LmdyYW50UmVhZFdyaXRlO1xuICAgIHRoaXMuZ3JhbnRXcml0ZSA9IHRoaXMuX2Nka0J1Y2tldC5ncmFudFdyaXRlO1xuICAgIHRoaXMub25DbG91ZFRyYWlsRXZlbnQgPSB0aGlzLl9jZGtCdWNrZXQub25DbG91ZFRyYWlsRXZlbnQ7XG4gICAgdGhpcy5vbkNsb3VkVHJhaWxQdXRPYmplY3QgPSB0aGlzLl9jZGtCdWNrZXQub25DbG91ZFRyYWlsUHV0T2JqZWN0O1xuICAgIHRoaXMub25DbG91ZFRyYWlsV3JpdGVPYmplY3QgPSB0aGlzLl9jZGtCdWNrZXQub25DbG91ZFRyYWlsV3JpdGVPYmplY3Q7XG4gICAgdGhpcy5zM1VybEZvck9iamVjdCA9IHRoaXMuX2Nka0J1Y2tldC5zM1VybEZvck9iamVjdDtcbiAgICB0aGlzLnRyYW5zZmVyQWNjZWxlcmF0aW9uVXJsRm9yT2JqZWN0ID0gdGhpcy5fY2RrQnVja2V0LnRyYW5zZmVyQWNjZWxlcmF0aW9uVXJsRm9yT2JqZWN0O1xuICAgIHRoaXMudXJsRm9yT2JqZWN0ID0gdGhpcy5fY2RrQnVja2V0LnVybEZvck9iamVjdDtcbiAgICB0aGlzLnZpcnR1YWxIb3N0ZWRVcmxGb3JPYmplY3QgPSB0aGlzLl9jZGtCdWNrZXQudmlydHVhbEhvc3RlZFVybEZvck9iamVjdDtcbiAgfVxuXG4gIHB1YmxpYyB1cmxGb3JPYmplY3QoX2tleT86IHN0cmluZyk6IHN0cmluZyB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdNZXRob2Qgbm90IGltcGxlbWVudGVkLicpO1xuICB9XG5cbiAgcHVibGljIHRyYW5zZmVyQWNjZWxlcmF0aW9uVXJsRm9yT2JqZWN0KF9rZXk/OiBzdHJpbmcsIF9vcHRpb25zPzogVHJhbnNmZXJBY2NlbGVyYXRpb25VcmxPcHRpb25zKTogc3RyaW5nIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgdmlydHVhbEhvc3RlZFVybEZvck9iamVjdChfa2V5Pzogc3RyaW5nLCBfb3B0aW9ucz86IFZpcnR1YWxIb3N0ZWRTdHlsZVVybE9wdGlvbnMpOiBzdHJpbmcge1xuICAgIHRocm93IG5ldyBFcnJvcignTWV0aG9kIG5vdCBpbXBsZW1lbnRlZC4nKTtcbiAgfVxuXG4gIHB1YmxpYyBzM1VybEZvck9iamVjdChfa2V5Pzogc3RyaW5nKTogc3RyaW5nIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgYXJuRm9yT2JqZWN0cyhfa2V5UGF0dGVybjogc3RyaW5nKTogc3RyaW5nIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgZ3JhbnRSZWFkKF9pZGVudGl0eTogSUdyYW50YWJsZSwgX29iamVjdHNLZXlQYXR0ZXJuPzogYW55KTogR3JhbnQge1xuICAgIHRocm93IG5ldyBFcnJvcignTWV0aG9kIG5vdCBpbXBsZW1lbnRlZC4nKTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudFdyaXRlKF9pZGVudGl0eTogSUdyYW50YWJsZSwgX29iamVjdHNLZXlQYXR0ZXJuPzogYW55KTogR3JhbnQge1xuICAgIHRocm93IG5ldyBFcnJvcignTWV0aG9kIG5vdCBpbXBsZW1lbnRlZC4nKTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudFB1dChfaWRlbnRpdHk6IElHcmFudGFibGUsIF9vYmplY3RzS2V5UGF0dGVybj86IGFueSk6IEdyYW50IHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgZ3JhbnRQdXRBY2woX2lkZW50aXR5OiBJR3JhbnRhYmxlLCBfb2JqZWN0c0tleVBhdHRlcm4/OiBzdHJpbmcpOiBHcmFudCB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdNZXRob2Qgbm90IGltcGxlbWVudGVkLicpO1xuICB9XG5cbiAgcHVibGljIGdyYW50RGVsZXRlKF9pZGVudGl0eTogSUdyYW50YWJsZSwgX29iamVjdHNLZXlQYXR0ZXJuPzogYW55KTogR3JhbnQge1xuICAgIHRocm93IG5ldyBFcnJvcignTWV0aG9kIG5vdCBpbXBsZW1lbnRlZC4nKTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudFJlYWRXcml0ZShfaWRlbnRpdHk6IElHcmFudGFibGUsIF9vYmplY3RzS2V5UGF0dGVybj86IGFueSk6IEdyYW50IHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgZ3JhbnRQdWJsaWNBY2Nlc3MoX2tleVByZWZpeD86IHN0cmluZywgLi4uX2FsbG93ZWRBY3Rpb25zOiBzdHJpbmdbXSk6IEdyYW50IHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgb25DbG91ZFRyYWlsRXZlbnQoX2lkOiBzdHJpbmcsIF9vcHRpb25zPzogT25DbG91ZFRyYWlsQnVja2V0RXZlbnRPcHRpb25zKTogUnVsZSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdNZXRob2Qgbm90IGltcGxlbWVudGVkLicpO1xuICB9XG5cbiAgcHVibGljIG9uQ2xvdWRUcmFpbFB1dE9iamVjdChfaWQ6IHN0cmluZywgX29wdGlvbnM/OiBPbkNsb3VkVHJhaWxCdWNrZXRFdmVudE9wdGlvbnMpOiBSdWxlIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgb25DbG91ZFRyYWlsV3JpdGVPYmplY3QoX2lkOiBzdHJpbmcsIF9vcHRpb25zPzogT25DbG91ZFRyYWlsQnVja2V0RXZlbnRPcHRpb25zKTogUnVsZSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdNZXRob2Qgbm90IGltcGxlbWVudGVkLicpO1xuICB9XG5cbiAgcHVibGljIGFkZEV2ZW50Tm90aWZpY2F0aW9uKF9ldmVudDogRXZlbnRUeXBlLCBfZGVzdDogSUJ1Y2tldE5vdGlmaWNhdGlvbkRlc3RpbmF0aW9uLCAuLi5fZmlsdGVyczogTm90aWZpY2F0aW9uS2V5RmlsdGVyW10pOiB2b2lkIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgYWRkT2JqZWN0Q3JlYXRlZE5vdGlmaWNhdGlvbihfZGVzdDogSUJ1Y2tldE5vdGlmaWNhdGlvbkRlc3RpbmF0aW9uLCAuLi5fZmlsdGVyczogTm90aWZpY2F0aW9uS2V5RmlsdGVyW10pOiB2b2lkIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgYWRkT2JqZWN0UmVtb3ZlZE5vdGlmaWNhdGlvbihfZGVzdDogSUJ1Y2tldE5vdGlmaWNhdGlvbkRlc3RpbmF0aW9uLCAuLi5fZmlsdGVyczogTm90aWZpY2F0aW9uS2V5RmlsdGVyW10pOiB2b2lkIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01ldGhvZCBub3QgaW1wbGVtZW50ZWQuJyk7XG4gIH1cblxuICBwdWJsaWMgZW5hYmxlRXZlbnRCcmlkZ2VOb3RpZmljYXRpb24oKTogdm9pZCB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdNZXRob2Qgbm90IGltcGxlbWVudGVkLicpO1xuICB9XG5cbiAgcHVibGljIGFkZFRvUmVzb3VyY2VQb2xpY3kocGVybWlzc2lvbjogUG9saWN5U3RhdGVtZW50KTogQWRkVG9SZXNvdXJjZVBvbGljeVJlc3VsdCB7XG4gICAgY29uc3QgcG9saWN5ID0gdGhpcy5wb2xpY3kgPz8gbmV3IEJ1Y2tldFBvbGljeSh0aGlzLCAncG9saWN5Jywge1xuICAgICAgYnVja2V0OiB0aGlzLFxuICAgIH0pO1xuICAgIHRoaXMucG9saWN5ID0gcG9saWN5O1xuXG4gICAgcG9saWN5LmRvY3VtZW50LmFkZFN0YXRlbWVudHMocGVybWlzc2lvbik7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN0YXRlbWVudEFkZGVkOiB0cnVlLFxuICAgICAgcG9saWN5RGVwZW5kYWJsZTogdGhpcy5wb2xpY3ksXG4gICAgfTtcbiAgfVxufSJdfQ==