import { ResourceProps } from 'aws-cdk-lib';
import { Construct, IConstruct } from 'constructs';
import { Database } from '../glue';
import { S3AccessLogsTable } from '../glue-tables';
import { RawBucket } from './private/raw-bucket';
export interface LoggingAspectOptions {
    readonly exclusions?: IConstruct[];
    readonly force?: boolean;
    readonly prefix?: string;
}
/**
 * Configuration for objects bucket
 */
export interface S3AccessLogsBucketProps extends ResourceProps {
    readonly bucketName?: string;
    readonly createQueries?: boolean;
    readonly database?: Database;
    readonly friendlyQueryNames?: boolean;
    readonly tableName?: string;
}
export declare class S3AccessLogsBucket extends RawBucket {
    readonly database: Database;
    readonly table: S3AccessLogsTable;
    readonly createQueries?: boolean;
    readonly friendlyQueryNames?: boolean;
    /**
       * Creates a new instance of the S3AccessLogsBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope: Construct, id: string, props?: S3AccessLogsBucketProps);
    addLoggingAspect(scope: IConstruct, options?: LoggingAspectOptions): void;
}
