"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafLogsBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const glue_1 = require("../glue");
const glue_tables_1 = require("../glue-tables");
const raw_bucket_1 = require("./private/raw-bucket");
class WafLogsBucket extends raw_bucket_1.RawBucket {
    /**
       * Creates a new instance of the WafLogsBucket class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in the construct tree.
       * @param id A name to be associated with the stack and used in resource naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            bucketEncryption: {
                serverSideEncryptionConfiguration: [
                    {
                        serverSideEncryptionByDefault: {
                            sseAlgorithm: 'AES256',
                        },
                    },
                ],
            },
            bucketName: props.bucketName ?? aws_cdk_lib_1.Lazy.string({
                produce: () => {
                    return `aws-waf-logs-${aws_cdk_lib_1.Names.uniqueId(this)}`;
                },
            }),
            publicAccessBlockConfiguration: {
                blockPublicAcls: true,
                blockPublicPolicy: true,
                ignorePublicAcls: true,
                restrictPublicBuckets: true,
            },
            versioningConfiguration: {
                status: 'Enabled',
            },
        });
        this.createQueries = props.createQueries;
        this.friendlyQueryNames = props.friendlyQueryNames;
        if (props.bucketName && !aws_cdk_lib_1.Token.isUnresolved(props.bucketName) && !props.bucketName.startsWith('aws-waf-logs-')) {
            aws_cdk_lib_1.Annotations.of(scope).addError("Buckets configured for WAF logs must start with 'aws-waf-logs-'.");
        }
        this.database = props.database ?? new glue_1.Database(this, 'database', {
            description: 'Database for storing AWS WAF logs',
        });
        this.table = new glue_tables_1.WafLogsTable(this, 'table', {
            bucket: this,
            createQueries: this.createQueries,
            database: this.database,
            friendlyQueryNames: this.friendlyQueryNames,
            name: props.tableName,
        });
    }
}
exports.WafLogsBucket = WafLogsBucket;
_a = JSII_RTTI_SYMBOL_1;
WafLogsBucket[_a] = { fqn: "cdk-extensions.s3_buckets.WafLogsBucket", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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