import { Duration } from 'aws-cdk-lib';
export interface CorsRuleConfiguration {
    readonly allowedHeaders?: string[];
    readonly allowedMethods: string[];
    readonly allowedOrigins: string[];
    readonly exposedHeaders?: string[];
    readonly id?: string;
    readonly maxAge?: Duration;
}
export interface CorsRuleOptions {
    readonly allowedHeaders?: string[];
    readonly allowedMethods?: string[];
    readonly allowedOrigins?: string[];
    readonly exposedHeaders?: string[];
    readonly id?: string;
    readonly maxAge?: Duration;
}
export declare class CorsRule implements CorsRuleConfiguration {
    private readonly _allowedHeaders;
    private readonly _allowedMethods;
    private readonly _allowedOrigins;
    private readonly _exposedHeaders;
    readonly allowedHeaders?: string[];
    readonly allowedMethods: string[];
    readonly allowedOrigins: string[];
    readonly exposedHeaders?: string[];
    readonly id?: string;
    readonly maxAge?: Duration;
    constructor(options: CorsRuleOptions);
    addAllowedHeader(header: string): CorsRule;
    addAllowedMethod(method: string): CorsRule;
    addAllowedOrigin(origin: string): CorsRule;
    addExposedHeader(header: string): CorsRule;
}
