"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CorsRule = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
class CorsRule {
    constructor(options) {
        // Internal properties
        this._allowedHeaders = [];
        this._allowedMethods = [];
        this._allowedOrigins = [];
        this._exposedHeaders = [];
        this.id = options.id;
        this.maxAge = options.maxAge;
        this.allowedHeaders = aws_cdk_lib_1.Lazy.list({
            produce: () => {
                return this._allowedHeaders;
            },
        }, {
            omitEmpty: true,
        });
        this.allowedMethods = aws_cdk_lib_1.Lazy.list({
            produce: () => {
                return this._allowedMethods;
            },
        });
        this.allowedOrigins = aws_cdk_lib_1.Lazy.list({
            produce: () => {
                return this._allowedOrigins;
            },
        });
        this.exposedHeaders = aws_cdk_lib_1.Lazy.list({
            produce: () => {
                return this._exposedHeaders;
            },
        }, {
            omitEmpty: true,
        });
    }
    addAllowedHeader(header) {
        this._allowedHeaders.push(header);
        return this;
    }
    addAllowedMethod(method) {
        this._allowedMethods.push(method);
        return this;
    }
    addAllowedOrigin(origin) {
        this._allowedOrigins.push(origin);
        return this;
    }
    addExposedHeader(header) {
        this._exposedHeaders.push(header);
        return this;
    }
}
exports.CorsRule = CorsRule;
//# sourceMappingURL=data:application/json;base64,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