"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Assignment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_sso_1 = require("aws-cdk-lib/aws-sso");
/**
 * Assigns access to a Principal for a specified AWS account using a specified
 * permission set.
 */
class Assignment extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the Assignment class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in
       * the construct tree.
       * @param id A name to be associated with the stack and used in resource
       * naming. Must be unique within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.instance = props.instance;
        this.permissionSet = props.permissionSet;
        this.principal = props.principal;
        this.target = props.target;
        this.resource = new aws_sso_1.CfnAssignment(this, 'Resource', {
            instanceArn: this.instance.instanceArn,
            permissionSetArn: this.permissionSet.permissionSetArn,
            principalId: this.principal.principalId,
            principalType: this.principal.principalType.name,
            targetId: this.target.targetId,
            targetType: this.target.targetType.name,
        });
    }
}
exports.Assignment = Assignment;
_a = JSII_RTTI_SYMBOL_1;
Assignment[_a] = { fqn: "cdk-extensions.sso.Assignment", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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