import { Resource, ResourceProps } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { IdentityCenterPrincipalType, IIdentityCenterPrincipal } from './lib/identity-center-principal';
export interface IGroup {
    readonly groupId: string;
}
export declare abstract class GroupBase extends Resource implements IGroup, IIdentityCenterPrincipal {
    readonly abstract groupId: string;
    readonly abstract principalId: string;
    readonly principalType: IdentityCenterPrincipalType;
    constructor(scope: IConstruct, id: string, props?: ResourceProps);
}
export declare class Group {
    static fromGroupId(scope: IConstruct, id: string, groupId: string): IGroup;
}
