"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Group = exports.GroupBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const identity_center_principal_1 = require("./lib/identity-center-principal");
class GroupBase extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.principalType = identity_center_principal_1.IdentityCenterPrincipalType.GROUP;
    }
}
exports.GroupBase = GroupBase;
_a = JSII_RTTI_SYMBOL_1;
GroupBase[_a] = { fqn: "cdk-extensions.sso.GroupBase", version: "0.0.20" };
class Group {
    static fromGroupId(scope, id, groupId) {
        class Import extends GroupBase {
            constructor() {
                super(scope, id);
                this.groupId = groupId;
                this.principalId = groupId;
            }
        }
        return new Import();
    }
}
exports.Group = Group;
_b = JSII_RTTI_SYMBOL_1;
Group[_b] = { fqn: "cdk-extensions.sso.Group", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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