"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceAccessControlAttributeConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_sso_1 = require("aws-cdk-lib/aws-sso");
const access_control_attribute_1 = require("./lib/access-control-attribute");
/**
 * Enables the attribute-based access control (ABAC) feature for the specified
 * IAM Identity Center instance. You can also specify new attributes to add to
 * your ABAC configuration during the enabling process. For more information
 * about ABAC, see [Attribute-Based Access Control](https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html) in the IAM Identity Center
 * User Guide.
 */
class InstanceAccessControlAttributeConfiguration extends aws_cdk_lib_1.Resource {
    /**
       * Creates a new instance of the
       * InstanceAccessControlAttributeConfiguration class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in
       * the construct tree.
       * @param id A name to be associated with the stack and used in resource
       * naming. Must be unique
       * within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props) {
        super(scope, id, props);
        // Internal properties
        this._attributes = [];
        this.instance = props.instance;
        this.resource = new aws_sso_1.CfnInstanceAccessControlAttributeConfiguration(this, 'Resource', {
            instanceArn: this.instance.instanceArn,
            accessControlAttributes: aws_cdk_lib_1.Lazy.any({
                produce: () => {
                    this._attributes.map((x) => {
                        return x.bind(this);
                    });
                },
            }, {
                omitEmptyArray: true,
            }),
        });
    }
    // Standard accessors
    /**
       * Lists the attributes that are configured for ABAC in the specified IAM
       * Identity Center instance. This array is readonly. Changes made to the
       * array will not be reflected in this resource. To add new attributes use
       * the `{@link addAttribute}` method.
       */
    get attributes() {
        return [...this._attributes];
    }
    /**
       * Adds a new ABAC attribute in the specified IAM Identity Center instance.
       *
       * @param key The name of the attribute associated with your identities in
       * your identity source. This is used to map a specified attribute in your
       * identity source with an attribute in IAM Identity Center.
       * @param sources The identity sources to use when mapping a specified
       * attribute to IAM Identity Center.
       * @returns An AccessControlAttribute resource that will be applied to the
       * configuration and supports continued management.
       */
    addAttribute(key, ...sources) {
        const attribute = new access_control_attribute_1.AccessControlAttribute({
            name: key,
            sources: sources,
        });
        this._attributes.push(attribute);
        return attribute;
    }
}
exports.InstanceAccessControlAttributeConfiguration = InstanceAccessControlAttributeConfiguration;
_a = JSII_RTTI_SYMBOL_1;
InstanceAccessControlAttributeConfiguration[_a] = { fqn: "cdk-extensions.sso.InstanceAccessControlAttributeConfiguration", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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