import { Resource } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
export interface IInstance {
    readonly instanceArn: string;
    readonly instanceId: string;
}
export declare abstract class InstanceBase extends Resource implements IInstance {
    readonly abstract instanceArn: string;
    readonly abstract instanceId: string;
}
export declare class Instance {
    static fromArn(scope: IConstruct, id: string, arn: string): IInstance;
    static fromInstanceId(scope: IConstruct, id: string, instanceId: string): IInstance;
}
