"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
class InstanceBase extends aws_cdk_lib_1.Resource {
}
exports.InstanceBase = InstanceBase;
_a = JSII_RTTI_SYMBOL_1;
InstanceBase[_a] = { fqn: "cdk-extensions.sso.InstanceBase", version: "0.0.20" };
class Instance {
    static fromArn(scope, id, arn) {
        class Import extends InstanceBase {
            constructor() {
                super(scope, id);
                this.instanceArn = arn;
                this.instanceId = aws_cdk_lib_1.Token.isUnresolved(arn) ? aws_cdk_lib_1.Fn.select(1, aws_cdk_lib_1.Fn.split('/', arn, 2)) : arn.split('/')[1];
            }
        }
        return new Import();
    }
    static fromInstanceId(scope, id, instanceId) {
        return Instance.fromArn(scope, id, aws_cdk_lib_1.Stack.of(scope).formatArn({
            account: '',
            region: '',
            resource: 'instance',
            resourceName: instanceId,
            service: 'sso',
        }));
    }
}
exports.Instance = Instance;
_b = JSII_RTTI_SYMBOL_1;
Instance[_b] = { fqn: "cdk-extensions.sso.Instance", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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