"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentityCenterPrincipalType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Provides a wrapper around the accepted values for the IAM Identity Center
 * [Assignment.PrincipalType attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-assignment.html#cfn-sso-assignment-principaltype).
 *
 * Accepted values are provided as static properties that can be used when
 * configuring an assignment.
 */
class IdentityCenterPrincipalType {
    /**
       * Creates a new instance of the IdentityCenterPrincipalType class.
       *
       * @param name The name for a type of IAM Identity Center Principal.
       */
    constructor(name) {
        this.name = name;
    }
    /**
       * An escape hatch method that allows specifying a custom principal types in
       * the even more options are added and the provided static types are yet to
       * catch up.
       *
       * It is recommended that the provided static types be used when possible
       * instead of calling `of`.
       *
       * @param name The name for a type of IAM Identity Center Principal.
       */
    static of(name) {
        return new IdentityCenterPrincipalType(name);
    }
}
exports.IdentityCenterPrincipalType = IdentityCenterPrincipalType;
_a = JSII_RTTI_SYMBOL_1;
IdentityCenterPrincipalType[_a] = { fqn: "cdk-extensions.sso.IdentityCenterPrincipalType", version: "0.0.20" };
/**
   * An IAM Identity Center group.
   */
IdentityCenterPrincipalType.GROUP = IdentityCenterPrincipalType.of('GROUP');
/**
   * An IAM Identity Center user.
   */
IdentityCenterPrincipalType.USER = IdentityCenterPrincipalType.of('USER');
//# sourceMappingURL=data:application/json;base64,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