import { IManagedPolicy } from 'aws-cdk-lib/aws-iam';
import { CfnPermissionSet } from 'aws-cdk-lib/aws-sso';
import { IConstruct } from 'constructs';
import { ReferencedManagedPolicy, ReferenceOptions } from './referenced-managed-policy';
export declare abstract class PermissionsBoundary {
    static fromManagedPolicy(policy: IManagedPolicy): ManagedPolicyPermissionsBoundary;
    static fromReference(options: ReferenceOptions): ReferencedPermissionsBoundary;
    abstract bind(scope: IConstruct): CfnPermissionSet.PermissionsBoundaryProperty;
}
export declare class ManagedPolicyPermissionsBoundary extends PermissionsBoundary {
    readonly managedPolicy: IManagedPolicy;
    constructor(policy: IManagedPolicy);
    bind(_scope: IConstruct): CfnPermissionSet.PermissionsBoundaryProperty;
}
export declare class ReferencedPermissionsBoundary extends PermissionsBoundary {
    readonly referencedPolicy: typeof ReferencedManagedPolicy;
    constructor(options: ReferenceOptions);
    bind(_scope: IConstruct): CfnPermissionSet.PermissionsBoundaryProperty;
}
