"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferencedPermissionsBoundary = exports.ManagedPolicyPermissionsBoundary = exports.PermissionsBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const referenced_managed_policy_1 = require("./referenced-managed-policy");
class PermissionsBoundary {
    static fromManagedPolicy(policy) {
        return new ManagedPolicyPermissionsBoundary(policy);
    }
    static fromReference(options) {
        return new ReferencedPermissionsBoundary(options);
    }
}
exports.PermissionsBoundary = PermissionsBoundary;
_a = JSII_RTTI_SYMBOL_1;
PermissionsBoundary[_a] = { fqn: "cdk-extensions.sso.PermissionsBoundary", version: "0.0.20" };
class ManagedPolicyPermissionsBoundary extends PermissionsBoundary {
    constructor(policy) {
        super();
        this.managedPolicy = policy;
    }
    bind(_scope) {
        return {
            managedPolicyArn: this.managedPolicy.managedPolicyArn,
        };
    }
}
exports.ManagedPolicyPermissionsBoundary = ManagedPolicyPermissionsBoundary;
_b = JSII_RTTI_SYMBOL_1;
ManagedPolicyPermissionsBoundary[_b] = { fqn: "cdk-extensions.sso.ManagedPolicyPermissionsBoundary", version: "0.0.20" };
class ReferencedPermissionsBoundary extends PermissionsBoundary {
    constructor(options) {
        super();
        this.referencedPolicy = referenced_managed_policy_1.ReferencedManagedPolicy.of(options);
    }
    bind(_scope) {
        return {
            customerManagedPolicyReference: {
                name: this.referencedPolicy.policyName,
                path: this.referencedPolicy.policyPath,
            },
        };
    }
}
exports.ReferencedPermissionsBoundary = ReferencedPermissionsBoundary;
_c = JSII_RTTI_SYMBOL_1;
ReferencedPermissionsBoundary[_c] = { fqn: "cdk-extensions.sso.ReferencedPermissionsBoundary", version: "0.0.20" };
//# sourceMappingURL=data:application/json;base64,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