"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReferencedManagedPolicy = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * A managed policy that is referenced via IAM Identity Center.
 */
class ReferencedManagedPolicy extends aws_iam_1.ManagedPolicy {
    /**
       * Creates a new instance of the ReferencedManagedPolicy class.
       *
       * @param scope A CDK Construct that will serve as this stack's parent in
       * the construct tree.
       * @param id A name to be associated with the stack and used in resource
       * naming. Must be unique within the context of 'scope'.
       * @param props Arguments related to the configuration of the resource.
       */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            managedPolicyName: aws_cdk_lib_1.Lazy.string({
                produce: () => {
                    return this.referencedName;
                },
            }),
            path: aws_cdk_lib_1.Lazy.string({
                produce: () => {
                    return this.referencedPath;
                },
            }),
        });
    }
    /**
       * Dynamically generates a new class that can be used to create a managed
       * policy that matches a reference in IAM Identity Center.
       *
       * @param options The reference configuration used when registering a
       * customer managed policy with a permission set in IAM Identity Center.
       * @returns A dynamically generated class that will match the provided
       * reference configuration.
       */
    static of(options) {
        class SsoReferencedManagedPolicy extends ReferencedManagedPolicy {
            constructor() {
                super(...arguments);
                this.referencedName = options.name;
                this.referencedPath = options.path;
            }
        }
        SsoReferencedManagedPolicy.policyName = options.name;
        SsoReferencedManagedPolicy.policyPath = options.path;
        return SsoReferencedManagedPolicy;
    }
}
exports.ReferencedManagedPolicy = ReferencedManagedPolicy;
_a = JSII_RTTI_SYMBOL_1;
ReferencedManagedPolicy[_a] = { fqn: "cdk-extensions.sso.ReferencedManagedPolicy", version: "0.0.20" };
// Static properties
/**
     * The name of the managed policy.
     */
ReferencedManagedPolicy.policyName = '<not-set>';
/**
     * The path for the managed policy.
     *
     * For more information about paths, see [IAM identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html) in the IAM User
     * Guide.
     */
ReferencedManagedPolicy.policyPath = undefined;
//# sourceMappingURL=data:application/json;base64,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